/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.kjs72.mixin.core.main;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.uncandango.kubejstweaks.kubejs.debug.DumpErroringRecipes;
import dev.uncandango.kubejstweaks.mixin.annotation.ConditionalMixin;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

@ConditionalMixin(modId="kubejs", versionRange="[2101.7.2,2101.7.3)")
@Mixin(value={KubeRecipe.class})
public class KubeRecipeMixin {
    @Shadow
    public ResourceLocation id;
    @Shadow
    public JsonObject json;

    @ModifyArg(method={"getOriginalRecipe"}, at=@At(value="INVOKE", target="Lcom/mojang/serialization/DataResult;ifError(Ljava/util/function/Consumer;)Lcom/mojang/serialization/DataResult;"), index=0)
    private Consumer<? super DataResult.Error<Object>> dumpErroringRecipe(Consumer<? super DataResult.Error<Object>> ifError) {
        return err -> {
            String origMessage = err.message();
            String targetMessage = origMessage.replaceAll("\\sin\\s.*?(;|$)", ";").replaceAll("Not a JSON object\\:\\s.*?(;|$)", "Not a JSON object;").replaceAll("Not a json array\\:\\s.*?(;|$)", "Not a json array;").replaceAll("recipe \\S+:\\S+:", "recipe;").replaceAll("with type\\:\\s.*?(;|$)", "with type;");
            DumpErroringRecipes.add((Throwable)new KubeRuntimeException(targetMessage, (Throwable)new IllegalArgumentException(err.message())), this.id, (JsonElement)this.json);
            if (DevProperties.get().logErroringParsedRecipes) {
                ConsoleJS.SERVER.error((Object)err.message());
            } else {
                RecipeManager.LOGGER.error(err.message());
            }
        };
    }
}

