/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.kubejs.schema;

import dev.uncandango.kubejstweaks.kubejs.schema.CodecParsedListener;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.bus.api.Event;

public class CodecNode {
    public CodecNode parent;
    public List<CodecNode> childs = new ArrayList<CodecNode>();
    public Event value;

    public CodecNode(Event value) {
        this.value = value;
    }

    public static List<CodecNode> flattenNodes(List<CodecNode> nodes) {
        ArrayList<CodecNode> result = new ArrayList<CodecNode>();
        nodes.forEach(node -> {
            result.add((CodecNode)node);
            result.addAll(CodecNode.flattenNodes(node.childs));
        });
        return result;
    }

    public void setParent(CodecNode parent) {
        this.parent = parent;
    }

    public void setChilds(List<CodecNode> childs) {
        childs.forEach(child -> child.setParent(this));
        this.childs = childs;
    }

    public boolean isSibling(CodecNode node) {
        return this.parent != null && node.parent != null && this.parent.hasSameKeyAndDecoder(node.parent);
    }

    public boolean hasSameKeyAndDecoder(CodecNode node) {
        return CodecParsedListener.getName(this.value).equals(CodecParsedListener.getName(node.value)) && CodecParsedListener.getDecoder(this.value).equals(CodecParsedListener.getDecoder(node.value)) && CodecParsedListener.getDepth(this.value) == CodecParsedListener.getDepth(node.value);
    }
}

