/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader.common.impl.packs;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.server.packs.PackType;

public record PackContentType(boolean data, boolean resources) {
    private static final PackContentType INVALID = new PackContentType(false, false);

    public boolean isFor(PackType type) {
        return this != INVALID && !this.data && !this.resources || type == PackType.SERVER_DATA && this.data || type == PackType.CLIENT_RESOURCES && this.resources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackContentType from(Path filePath) {
        if (!Files.isRegularFile(filePath, new LinkOption[0])) {
            if (!Files.isDirectory(filePath, new LinkOption[0])) return INVALID;
            if (!Files.isRegularFile(filePath.resolve("pack.mcmeta"), new LinkOption[0])) return INVALID;
            return new PackContentType(Files.isDirectory(filePath.resolve("data"), new LinkOption[0]), Files.isDirectory(filePath.resolve("assets"), new LinkOption[0]));
        }
        try (FileSystem fs = FileSystems.newFileSystem(filePath);){
            if (!Files.isRegularFile(fs.getPath("pack.mcmeta", new String[0]), new LinkOption[0])) return INVALID;
            PackContentType packContentType = new PackContentType(Files.isDirectory(fs.getPath("data/", new String[0]), new LinkOption[0]), Files.isDirectory(fs.getPath("assets/", new String[0]), new LinkOption[0]));
            return packContentType;
        }
        catch (IOException iOException) {
            return INVALID;
        }
    }
}

