/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item.decoration;

import com.google.common.collect.ImmutableList;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.decorative.PaperWallBlock;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.item.BlockItemWithClientBePlacement;
import com.ldtteam.domumornamentum.item.interfaces.IDoItem;
import com.ldtteam.domumornamentum.util.BlockUtils;
import com.ldtteam.domumornamentum.util.Constants;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class PaperwallBlockItem
extends BlockItemWithClientBePlacement
implements IDoItem {
    private final PaperWallBlock paperWallBlock;

    public PaperwallBlockItem(PaperWallBlock blockIn, Item.Properties builder) {
        super((Block)blockIn, builder);
        this.paperWallBlock = blockIn;
    }

    @NotNull
    public Component getName(ItemStack stack) {
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.paperWallBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        return Component.translatable((String)("domum_ornamentum." + this.builtInRegistryHolder().key().location().getPath() + ".name.format"), (Object[])new Object[]{centerBlockName});
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext tooltipContext, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, tooltipContext, tooltip, flagIn);
        MaterialTextureData textureData = MaterialTextureData.readFromItemStack(stack);
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(stack);
        }
        String id = this.builtInRegistryHolder().key().location().getPath();
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.origin.tooltip"));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)("domum_ornamentum." + id + ".header")));
        IMateriallyTexturedBlockComponent frameComponent = (IMateriallyTexturedBlockComponent)this.paperWallBlock.getComponents().get(0);
        Block frameBlock = textureData.getTexturedComponents().getOrDefault(frameComponent.getId(), frameComponent.getDefault());
        Component frameBlockName = BlockUtils.getHoverName(frameBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.frame", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{frameBlockName})}));
        IMateriallyTexturedBlockComponent centerComponent = (IMateriallyTexturedBlockComponent)this.paperWallBlock.getComponents().get(1);
        Block centerBlock = textureData.getTexturedComponents().getOrDefault(centerComponent.getId(), centerComponent.getDefault());
        Component centerBlockName = BlockUtils.getHoverName(centerBlock);
        tooltip.add((Component)Component.translatable((String)"domum_ornamentum.desc.center", (Object[])new Object[]{Component.translatable((String)"domum_ornamentum.desc.material", (Object[])new Object[]{centerBlockName})}));
    }

    @Override
    public List<ResourceLocation> getInputIds() {
        return ImmutableList.of((Object)Constants.resLocDO("frame"), (Object)Constants.resLocDO("center"));
    }

    @Override
    public ResourceLocation getGroup() {
        return Constants.resLocDO("hpaperwall");
    }
}

