/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.stateless.StatelessAnimatable;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.network.packet.MultiloaderPacket;
import software.bernie.geckolib.util.ClientUtil;
import software.bernie.geckolib.util.RenderUtil;

public record StatelessEntityPlayAnimPacket(int entityId, boolean isReplacedEntity, RawAnimation animation) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<StatelessEntityPlayAnimPacket> TYPE = new CustomPacketPayload.Type(GeckoLibConstants.id("stateless_entity_play_anim"));
    public static final StreamCodec<FriendlyByteBuf, StatelessEntityPlayAnimPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, StatelessEntityPlayAnimPacket::entityId, (StreamCodec)ByteBufCodecs.BOOL, StatelessEntityPlayAnimPacket::isReplacedEntity, RawAnimation.STREAM_CODEC, StatelessEntityPlayAnimPacket::animation, StatelessEntityPlayAnimPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(@Nullable Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            GeoAnimatable entityAnimatable;
            GeoAnimatable animatable;
            Entity entity = ClientUtil.getLevel().getEntity(this.entityId);
            if (entity == null) {
                return;
            }
            GeoAnimatable geoAnimatable = this.isReplacedEntity ? RenderUtil.getReplacedAnimatable(entity.getType()) : (animatable = entity instanceof GeoAnimatable ? (entityAnimatable = (GeoAnimatable)entity) : null);
            if (animatable instanceof StatelessAnimatable) {
                StatelessAnimatable statelessAnimatable = (StatelessAnimatable)((Object)animatable);
                statelessAnimatable.handleClientAnimationPlay(animatable, this.entityId, this.animation);
            }
        });
    }
}

