/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.datagen;

import com.github.jarva.allthearcanistgear.common.items.perks.FlightPerk;
import com.github.jarva.allthearcanistgear.common.items.perks.SpectralSightPerk;
import com.github.jarva.allthearcanistgear.common.items.perks.TruesightPerk;
import com.github.jarva.allthearcanistgear.common.items.perks.VitalityPerk;
import com.github.jarva.allthearcanistgear.datagen.Setup;
import com.hollingsworth.arsnouveau.api.perk.Perk;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeBuilder;
import com.hollingsworth.arsnouveau.common.datagen.ApparatusRecipeProvider;
import com.hollingsworth.arsnouveau.common.items.PerkItem;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.nio.file.Path;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ApparatusRecipeDatagen
extends ApparatusRecipeProvider {
    public ApparatusRecipeDatagen(DataGenerator generatorIn) {
        super(generatorIn);
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/" + Setup.root + "/recipe/apparatus/" + str + ".json");
    }

    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (ApparatusRecipeBuilder.RecipeWrapper recipe : this.recipes) {
            Path path = ApparatusRecipeDatagen.getRecipePath(this.output, recipe.id().getPath());
            this.saveStable(pOutput, recipe.serialize(), path);
        }
    }

    public void addEntries() {
        this.buildThread(this.getPerkItem(FlightPerk.INSTANCE), new ItemLike[]{ItemsRegistry.AIR_ESSENCE, Items.PHANTOM_MEMBRANE, ItemsRegistry.AIR_ESSENCE, Items.PHANTOM_MEMBRANE, ItemsRegistry.AIR_ESSENCE, Items.PHANTOM_MEMBRANE});
        this.buildThread(this.getPerkItem(TruesightPerk.INSTANCE), new ItemLike[]{Items.GOLDEN_CARROT, Items.GOLDEN_CARROT, Items.GOLDEN_CARROT});
        this.buildThread(this.getPerkItem(VitalityPerk.INSTANCE), new ItemLike[]{Items.ENCHANTED_GOLDEN_APPLE, Items.GLISTERING_MELON_SLICE, Items.GLISTERING_MELON_SLICE});
        this.buildThread(this.getPerkItem(SpectralSightPerk.INSTANCE), new ItemLike[]{Items.SPECTRAL_ARROW, Items.GOLDEN_CARROT, Items.GLOW_INK_SAC});
    }

    public void buildThread(PerkItem output, ItemLike ... pedestal) {
        this.buildThread(ItemsRegistry.BLANK_THREAD, output, pedestal);
    }

    public void buildThread(PerkItem reagent, PerkItem output, ItemLike ... pedestal) {
        ApparatusRecipeBuilder build = this.builder().withReagent((ItemLike)ItemsRegistry.BLANK_THREAD).withResult((ItemLike)output);
        for (ItemLike item : pedestal) {
            build = build.withPedestalItem(item);
        }
        this.addRecipe(build.build());
    }

    public PerkItem getPerkItem(Perk id) {
        return super.getPerkItem(id.getRegistryName());
    }
}

