/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.client.render;

import codechicken.enderstorage.client.Shaders;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.util.ClientUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Transformation;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;

public class RenderCustomEndPortal {
    private static final RenderType STARFIELD_TYPE = RenderType.create((String)"starfield", (VertexFormat)DefaultVertexFormat.POSITION, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(new RenderStateShard.ShaderStateShard(Shaders::starfieldShader)).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TheEndPortalRenderer.END_PORTAL_LOCATION, false, false)).createCompositeState(false));
    private final double surfaceY;
    private final double surfaceX1;
    private final double surfaceX2;
    private final double surfaceZ1;
    private final double surfaceZ2;

    public RenderCustomEndPortal(double y, double x1, double x2, double z1, double z2) {
        this.surfaceY = y;
        this.surfaceX1 = x1;
        this.surfaceX2 = x2;
        this.surfaceZ1 = z1;
        this.surfaceZ2 = z2;
    }

    public void render(Matrix4 mat, MultiBufferSource source) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        assert (localPlayer != null);
        Shaders.starfieldTime().glUniform1f((float)ClientUtils.getRenderTime());
        Shaders.starfieldYaw().glUniform1f((float)((double)localPlayer.getYRot() * 0.017453292519943));
        Shaders.starfieldPitch().glUniform1f((float)(-((double)localPlayer.getXRot() * 0.017453292519943)));
        TransformingVertexConsumer cons = new TransformingVertexConsumer(source.getBuffer(STARFIELD_TYPE), (Transformation)mat);
        cons.addVertex((float)this.surfaceX1, (float)this.surfaceY, (float)this.surfaceZ1);
        cons.addVertex((float)this.surfaceX1, (float)this.surfaceY, (float)this.surfaceZ2);
        cons.addVertex((float)this.surfaceX2, (float)this.surfaceY, (float)this.surfaceZ2);
        cons.addVertex((float)this.surfaceX2, (float)this.surfaceY, (float)this.surfaceZ1);
    }

    public void render(PoseStack pStack, MultiBufferSource source) {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        assert (localPlayer != null);
        Shaders.starfieldTime().glUniform1f((float)ClientUtils.getRenderTime());
        Shaders.starfieldYaw().glUniform1f((float)((double)localPlayer.getYRot() * 0.017453292519943));
        Shaders.starfieldPitch().glUniform1f((float)(-((double)localPlayer.getXRot() * 0.017453292519943)));
        VertexConsumer cons = source.getBuffer(STARFIELD_TYPE);
        cons.addVertex(pStack.last().pose(), (float)this.surfaceX1, (float)this.surfaceY, (float)this.surfaceZ1);
        cons.addVertex(pStack.last().pose(), (float)this.surfaceX1, (float)this.surfaceY, (float)this.surfaceZ2);
        cons.addVertex(pStack.last().pose(), (float)this.surfaceX2, (float)this.surfaceY, (float)this.surfaceZ2);
        cons.addVertex(pStack.last().pose(), (float)this.surfaceX2, (float)this.surfaceY, (float)this.surfaceZ1);
    }
}

