/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import commoble.morered.MoreRed;
import commoble.morered.wire_post.AbstractPoweredWirePostBlock;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WirePostBlockEntity;
import commoble.morered.wire_post.WireSpoolItem;
import java.util.Set;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class WirePostRenderer
implements BlockEntityRenderer<WirePostBlockEntity> {
    public WirePostRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static int getRed(Level world, BlockPos pos, BlockState state, float partialTicks) {
        int light = world.getMaxLocalRawBrightness(pos);
        float celestialAngle = world.getSunAngle(partialTicks);
        if (light > 0) {
            float offset = celestialAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            celestialAngle += (offset - celestialAngle) * 0.2f;
            light = Math.round((float)light * Mth.cos((float)celestialAngle));
        }
        light = Math.max(light, world.getBrightness(LightLayer.BLOCK, pos));
        light = Mth.clamp((int)light, (int)0, (int)15);
        int power = state.hasProperty((Property)AbstractPoweredWirePostBlock.POWER) ? (Integer)state.getValue((Property)AbstractPoweredWirePostBlock.POWER) : 0;
        double lerpFactor = (double)power / 15.0;
        return (int)Mth.lerp((double)lerpFactor, (double)86.0, (double)255.0) * light / 15;
    }

    public void render(WirePostBlockEntity post, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockPos postPos = post.getBlockPos();
        Vec3 postVector = Vec3.atCenterOf((Vec3i)postPos);
        Set<BlockPos> connections = post.getRemoteConnections();
        Level world = post.getLevel();
        BlockState postState = world.getBlockState(postPos);
        VertexConsumer vertexBuilder = buffer.getBuffer(RenderType.lines());
        int postRed = WirePostRenderer.getRed(world, postPos, postState, partialTicks);
        for (BlockPos connectionPos : connections) {
            BlockState otherState = world.getBlockState(connectionPos);
            int red = Math.min(postRed, WirePostRenderer.getRed(world, connectionPos, otherState, partialTicks));
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, postVector, Vec3.atCenterOf((Vec3i)connectionPos), 0.0f, red);
        }
        LocalPlayer player = Minecraft.getInstance().player;
        for (InteractionHand hand : InteractionHand.values()) {
            float eyeHeight;
            double handZ;
            double handY;
            double handX;
            BlockPos positionOfCurrentPostOfPlayer;
            ItemStack stack = player.getItemInHand(hand);
            if (!(stack.getItem() instanceof WireSpoolItem) || (positionOfCurrentPostOfPlayer = (BlockPos)stack.get((DataComponentType)MoreRed.get().spooledPostComponent.get())) == null || !positionOfCurrentPostOfPlayer.equals((Object)postPos)) continue;
            EntityRenderDispatcher renderManager = Minecraft.getInstance().getEntityRenderDispatcher();
            Vec3 vectorOfCurrentPostOfPlayer = Vec3.atCenterOf((Vec3i)positionOfCurrentPostOfPlayer);
            int handSideID = -(hand == InteractionHand.MAIN_HAND ? -1 : 1) * (player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1);
            float swingProgress = player.getAttackAnim(partialTicks);
            float swingZ = Mth.sin((float)(Mth.sqrt((float)swingProgress) * (float)Math.PI));
            float playerAngle = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            double playerAngleX = Mth.sin((float)playerAngle);
            double playerAngleZ = Mth.cos((float)playerAngle);
            double handOffset = (double)handSideID * 0.35;
            if (renderManager.options == null || renderManager.options.getCameraType() == CameraType.FIRST_PERSON) {
                double fov = ((Integer)renderManager.options.fov().get()).intValue();
                Vec3 handVector = new Vec3(-0.14 + (double)handSideID * -0.36 * (fov /= 100.0), -0.12 + -0.045 * fov, 0.4);
                handVector = handVector.xRot(-Mth.lerp((float)partialTicks, (float)player.xRotO, (float)player.getXRot()) * ((float)Math.PI / 180));
                handVector = handVector.yRot(-Mth.lerp((float)partialTicks, (float)player.yRotO, (float)player.getYRot()) * ((float)Math.PI / 180));
                handVector = handVector.yRot(swingZ * 0.5f);
                handVector = handVector.xRot(-swingZ * 0.7f);
                handX = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) + handVector.x;
                handY = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + handVector.y;
                handZ = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) + handVector.z;
                eyeHeight = player.getEyeHeight();
            } else {
                handX = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) - playerAngleZ * handOffset - playerAngleX * 0.8;
                handY = -0.2 + player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)partialTicks - 0.45;
                handZ = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) - playerAngleX * handOffset + playerAngleZ * 0.8;
                eyeHeight = player.isCrouching() ? -0.1875f : 0.0f;
            }
            Vec3 renderPlayerVec = new Vec3(handX, handY + (double)eyeHeight, handZ);
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, vectorOfCurrentPostOfPlayer, renderPlayerVec, eyeHeight, postRed);
        }
    }

    private void renderConnection(WirePostBlockEntity post, Level world, float partialTicks, PoseStack poseStack, VertexConsumer vertexBuilder, Vec3 startPos, Vec3 endPos, float eyeHeight, int red) {
        poseStack.pushPose();
        boolean translateSwap = false;
        if (startPos.y() > endPos.y()) {
            Vec3 swap = startPos;
            startPos = endPos;
            endPos = swap;
            translateSwap = true;
        }
        poseStack.translate(0.5, 0.5, 0.5);
        double startX = startPos.x();
        double startY = startPos.y();
        double startZ = startPos.z();
        double endX = endPos.x();
        double endY = endPos.y();
        double endZ = endPos.z();
        float dx = (float)(endX - startX);
        float dy = (float)(endY - startY);
        float dz = (float)(endZ - startZ);
        if (translateSwap) {
            poseStack.translate(-dx, -dy, -dz);
        }
        Matrix4f fourMatrix = poseStack.last().pose();
        if (startY <= endY) {
            Vec3[] pointList = SlackInterpolator.getInterpolatedDifferences(endPos.subtract(startPos));
            int points = pointList.length;
            int lines = points - 1;
            poseStack.pushPose();
            for (int line = 0; line < lines; ++line) {
                Vec3 firstPoint = pointList[line];
                Vec3 secondPoint = pointList[line + 1];
                vertexBuilder.addVertex(fourMatrix, (float)firstPoint.x(), (float)firstPoint.y(), (float)firstPoint.z()).setColor(red, 0, 0, 255).setNormal((float)firstPoint.x(), (float)firstPoint.y(), (float)firstPoint.z());
                vertexBuilder.addVertex(fourMatrix, (float)secondPoint.x(), (float)secondPoint.y(), (float)secondPoint.z()).setColor(red, 0, 0, 255).setNormal((float)secondPoint.x(), (float)secondPoint.y(), (float)secondPoint.z());
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(WirePostBlockEntity te) {
        return true;
    }

    public AABB getRenderBoundingBox(WirePostBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }
}

