/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.plate_blocks;

import commoble.morered.plate_blocks.InputSide;
import commoble.morered.plate_blocks.InputState;
import commoble.morered.plate_blocks.LogicFunction;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.plate_blocks.RedstonePlateBlock;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class LogicFunctionPlateBlock
extends RedstonePlateBlock {
    public static final DirectionProperty ATTACHMENT_DIRECTION = PlateBlockStateProperties.ATTACHMENT_DIRECTION;
    public static final IntegerProperty ROTATION = PlateBlockStateProperties.ROTATION;
    public static final int OUTPUT_STRENGTH = 15;
    public static final int TICK_DELAY = 1;
    public static final LogicFunctionPlateBlockFactory THREE_INPUTS = LogicFunctionPlateBlock.getBlockFactory(InputSide.A, InputSide.B, InputSide.C);
    public static final LogicFunctionPlateBlockFactory T_INPUTS = LogicFunctionPlateBlock.getBlockFactory(InputSide.A, InputSide.C);
    public static final LogicFunctionPlateBlockFactory LINEAR_INPUT = LogicFunctionPlateBlock.getBlockFactory(InputSide.B);
    private final LogicFunction function;

    public static LogicFunctionPlateBlockFactory getBlockFactory(final InputSide ... inputs) {
        return (properties, function) -> new LogicFunctionPlateBlock(function, properties){

            @Override
            public InputSide[] getInputSides() {
                return inputs;
            }
        };
    }

    public LogicFunctionPlateBlock(BlockBehaviour.Properties properties, LogicFunction function) {
        super(properties);
        this.function = function;
        BlockState baseState = this.defaultBlockState();
        for (InputSide side : this.getInputSides()) {
            baseState = (BlockState)baseState.setValue((Property)side.property, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(baseState);
    }

    @Override
    public abstract InputSide[] getInputSides();

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        for (InputSide side : this.getInputSides()) {
            builder.add(new Property[]{side.property});
        }
    }

    @Deprecated
    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction sideOfAdjacentBlock) {
        if (InputState.getInput(blockState).applyLogic(this.function) && PlateBlockStateProperties.getOutputDirection(blockState) == sideOfAdjacentBlock.getOpposite()) {
            return 15;
        }
        return 0;
    }

    public void tick(BlockState oldBlockState, ServerLevel world, BlockPos pos, RandomSource rand) {
        BlockState newBlockState = InputState.getUpdatedBlockState((Level)world, oldBlockState, pos);
        if (newBlockState != oldBlockState) {
            world.setBlock(pos, newBlockState, 2);
        }
    }

    @Override
    public EnumSet<Direction> getOutputSides(Level level, BlockPos pos, BlockState state) {
        return EnumSet.of(PlateBlockStateProperties.getOutputDirection(state));
    }

    @FunctionalInterface
    public static interface LogicFunctionPlateBlockFactory {
        public LogicFunctionPlateBlock makeBlock(LogicFunction var1, BlockBehaviour.Properties var2);
    }
}

