/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.soldering;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import commoble.morered.MoreRed;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.jetbrains.annotations.NotNull;

public record SolderingRecipe(ItemStack result, List<SizedIngredient> ingredients) implements Recipe<CraftingInput>
{
    public static final MapCodec<SolderingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("result").forGetter(SolderingRecipe::result), (App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(SolderingRecipe::ingredients)).apply((Applicative)builder, SolderingRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SolderingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, SolderingRecipe::result, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), SolderingRecipe::ingredients, SolderingRecipe::new);

    public RecipeType<?> getType() {
        return (RecipeType)MoreRed.get().solderingRecipeType.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MoreRed.get().solderingSerializer.get();
    }

    public static boolean doesPlayerHaveIngredients(Inventory playerInventory, @NotNull SolderingRecipe recipe) {
        List<SizedIngredient> ingredients = recipe.ingredients();
        for (SizedIngredient ingredient : ingredients) {
            int remainingItems = ingredient.count();
            int playerSlots = playerInventory.getContainerSize();
            for (int playerSlot = 0; playerSlot < playerSlots && remainingItems > 0; ++playerSlot) {
                ItemStack stackInSlot = playerInventory.getItem(playerSlot);
                if (!ingredient.test(stackInSlot)) continue;
                remainingItems -= stackInSlot.getCount();
            }
            if (remainingItems <= 0) continue;
            return false;
        }
        return true;
    }

    public boolean matches(CraftingInput input, Level level) {
        return false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return x * y <= this.ingredients.size();
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean showNotification() {
        return false;
    }
}

