/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import commoble.morered.MoreRed;
import commoble.morered.wire_post.AbstractPostBlock;
import commoble.morered.wire_post.WirePostBlockEntity;
import java.util.EnumSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public abstract class AbstractPoweredWirePostBlock
extends AbstractPostBlock
implements EntityBlock {
    public static final IntegerProperty POWER = BlockStateProperties.POWER;
    public static final EnumSet<Direction> NO_DIRECTIONS = EnumSet.noneOf(Direction.class);
    protected static final VoxelShape[] POST_SHAPES_DUNSWE = new VoxelShape[]{Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0), Block.box((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.box((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0)};
    private final Function<BlockState, EnumSet<Direction>> connectionGetter;

    public AbstractPoweredWirePostBlock(BlockBehaviour.Properties properties, Function<BlockState, EnumSet<Direction>> connectionGetter) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.connectionGetter = connectionGetter;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().redwirePostBeType.get()).create(pos, state);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{POWER});
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        int newPower;
        int oldPower = (Integer)state.getValue((Property)POWER);
        if (oldPower != (newPower = this.getNewPower(state, (LevelAccessor)world, pos))) {
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
    }

    @Deprecated
    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, blockIn, fromPos, isMoving);
        int oldPower = (Integer)state.getValue((Property)POWER);
        int newPower = this.getNewPower(state, (LevelAccessor)world, pos);
        if (oldPower != newPower) {
            world.setBlock(pos, (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(newPower)), 3);
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState attachmentState = super.getStateForPlacement(context);
        return attachmentState == null ? null : (BlockState)attachmentState.setValue((Property)POWER, (Comparable)Integer.valueOf(this.getNewPower(attachmentState, (LevelAccessor)context.getLevel(), context.getClickedPos())));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(this.getNewPower(state, world, pos)));
    }

    @Deprecated
    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return side != null && this.getConnectableDirections(state).contains(side.getOpposite());
    }

    @Deprecated
    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction directionOfThisBlockFromCaller) {
        if (this.getConnectableDirections(blockState).contains(directionOfThisBlockFromCaller.getOpposite())) {
            return (Integer)blockState.getValue((Property)POWER);
        }
        return 0;
    }

    @Deprecated
    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor) {
        return this.getSignal(state, world, pos, directionFromNeighbor);
    }

    public EnumSet<Direction> getConnectableDirections(BlockState state) {
        return this.connectionGetter.apply(state);
    }

    public int getNewPower(BlockState state, LevelAccessor world, BlockPos pos) {
        return Math.max(0, Math.max(this.getNeighborPower(state, world, pos), this.getConnectionPower(state, world, pos)) - 1);
    }

    public int getNeighborPower(BlockState state, LevelAccessor world, BlockPos pos) {
        int maxPowerFound = 0;
        if (world instanceof Level) {
            Level level = (Level)world;
            for (Direction dir : this.getConnectableDirections(state)) {
                int signal = level.getSignal(pos.relative(dir), dir);
                maxPowerFound = Math.max(signal, maxPowerFound);
            }
        }
        return maxPowerFound;
    }

    public int getConnectionPower(BlockState state, LevelAccessor world, BlockPos pos) {
        int maxPowerFound = 0;
        BlockEntity be = world.getBlockEntity(pos);
        if (be instanceof WirePostBlockEntity) {
            WirePostBlockEntity wire = (WirePostBlockEntity)be;
            for (BlockPos otherPos : wire.getRemoteConnections()) {
                BlockState otherState = world.getBlockState(otherPos);
                if (!otherState.hasProperty((Property)POWER)) continue;
                maxPowerFound = Math.max(maxPowerFound, (Integer)otherState.getValue((Property)POWER));
            }
        }
        return maxPowerFound;
    }

    @Override
    public void notifyNeighbors(Level world, BlockPos pos, BlockState state) {
        EnumSet<Direction> neighborDirections = this.getConnectableDirections(state);
        if (!EventHooks.onNeighborNotify((Level)world, (BlockPos)pos, (BlockState)world.getBlockState(pos), neighborDirections, (boolean)false).isCanceled()) {
            for (Direction dir : neighborDirections) {
                BlockPos neighborPos = pos.relative(dir);
                world.neighborChanged(neighborPos, (Block)this, pos);
                if (!world.getBlockState(neighborPos).shouldCheckWeakPower((SignalGetter)world, neighborPos, dir)) continue;
                world.updateNeighborsAt(neighborPos, (Block)this);
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof WirePostBlockEntity) {
                WirePostBlockEntity wire = (WirePostBlockEntity)blockEntity;
                wire.notifyConnections();
            }
        }
    }
}

