/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.LoadingCache;
import commoble.morered.MoreRed;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.api.WireConnector;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.WireBlockEntity;
import java.util.EnumSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.event.EventHooks;

public abstract class PoweredWireBlock
extends AbstractWireBlock
implements EntityBlock {
    public PoweredWireBlock(BlockBehaviour.Properties properties, VoxelShape[] shapesByStateIndex, VoxelShape[] raytraceBackboards, LoadingCache<Long, VoxelShape> voxelCache, boolean useIndirectPower) {
        super(properties, shapesByStateIndex, raytraceBackboards, voxelCache, useIndirectPower);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().wireBeType.get()).create(pos, state);
    }

    public boolean isSignalSource(BlockState state) {
        return !this.isEmptyWireBlock(state);
    }

    public int getSignal(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor) {
        return this.getPower(state, world, pos, directionFromNeighbor, false);
    }

    public int getDirectSignal(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor) {
        return this.useIndirectPower ? this.getPower(state, world, pos, directionFromNeighbor, false) : 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction directionFromNeighbor) {
        if (directionFromNeighbor == null) {
            return false;
        }
        Direction directionToNeighbor = directionFromNeighbor.getOpposite();
        int side = directionToNeighbor.ordinal();
        if (((Boolean)state.getValue((Property)INTERIOR_FACES[side])).booleanValue()) {
            return true;
        }
        for (int subSide = 0; subSide < 4; ++subSide) {
            int orthagonalSide = DirectionHelper.uncompressSecondSide(side, subSide);
            if (!((Boolean)state.getValue((Property)INTERIOR_FACES[orthagonalSide])).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected int getPower(BlockState state, BlockGetter world, BlockPos pos, Direction directionFromNeighbor, boolean expand) {
        BlockEntity te = world.getBlockEntity(pos);
        if (!(te instanceof WireBlockEntity)) {
            return 0;
        }
        WireBlockEntity wire = (WireBlockEntity)te;
        Direction directionToNeighbor = directionFromNeighbor.getOpposite();
        int side = directionToNeighbor.ordinal();
        if (((Boolean)state.getValue((Property)INTERIOR_FACES[side])).booleanValue()) {
            int power = wire.getPower(side);
            return expand ? power : power / 2;
        }
        BlockPos neighborPos = pos.relative(directionToNeighbor);
        BlockState neighborState = world.getBlockState(neighborPos);
        WireConnector connector = MoreRedAPI.getWireConnectabilityRegistry().getOrDefault(neighborState.getBlock(), MoreRedAPI.getDefaultWireConnector());
        int output = 0;
        for (int i = 0; i < 4; ++i) {
            int attachmentSide = DirectionHelper.uncompressSecondSide(side, i);
            Direction attachmentDirection = Direction.from3DDataValue((int)attachmentSide);
            if (!((Boolean)state.getValue((Property)INTERIOR_FACES[attachmentSide])).booleanValue() || !connector.canConnectToAdjacentWire(world, neighborPos, neighborState, pos, state, attachmentDirection, directionFromNeighbor)) continue;
            output = Math.max(output, wire.getPower(attachmentSide));
        }
        return expand ? output : output / 2;
    }

    public int getExpandedPower(Level world, BlockPos thisPos, BlockState thisState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionFromWire) {
        BlockEntity te = world.getBlockEntity(thisPos);
        if (!(te instanceof WireBlockEntity)) {
            return 0;
        }
        WireBlockEntity wire = (WireBlockEntity)te;
        return (Boolean)thisState.getValue((Property)INTERIOR_FACES[wireFace.ordinal()]) != false ? wire.getPower(wireFace) : 0;
    }

    @Override
    protected void updatePowerAfterBlockUpdate(Level world, BlockPos wirePos, BlockState wireState) {
        BlockEntity te = world.getBlockEntity(wirePos);
        if (!(te instanceof WireBlockEntity)) {
            return;
        }
        WireBlockEntity wire = (WireBlockEntity)te;
        Map<Block, WireConnector> connectors = MoreRedAPI.getWireConnectabilityRegistry();
        Map<Block, ExpandedPowerSupplier> expandedPowerSuppliers = MoreRedAPI.getExpandedPowerRegistry();
        WireConnector defaultConnector = MoreRedAPI.getDefaultWireConnector();
        ExpandedPowerSupplier defaultPowerSupplier = MoreRedAPI.getDefaultExpandedPowerSupplier();
        BlockPos.MutableBlockPos mutaPos = wirePos.mutable();
        BlockState[] neighborStates = new BlockState[6];
        boolean anyPowerUpdated = false;
        EnumSet<Direction> facesNeedingUpdates = EnumSet.noneOf(Direction.class);
        boolean[] attachedFaceStates = new boolean[6];
        for (int attachmentSide = 0; attachmentSide < 6; ++attachmentSide) {
            if (((Boolean)wireState.getValue((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) {
                attachedFaceStates[attachmentSide] = true;
                facesNeedingUpdates.add(Direction.from3DDataValue((int)attachmentSide));
                continue;
            }
            if (!wire.setPower(attachmentSide, 0)) continue;
            anyPowerUpdated = true;
        }
        int iteration = 0;
        while (!facesNeedingUpdates.isEmpty()) {
            BlockState attachedNeighborState;
            int attachmentSide;
            Direction attachmentDirection;
            if (!facesNeedingUpdates.remove(attachmentDirection = Direction.from3DDataValue((int)(attachmentSide = iteration++ % 6)))) continue;
            int power = 0;
            mutaPos.setWithOffset((Vec3i)wirePos, attachmentDirection);
            BlockState attachedNeighborStateCheck = neighborStates[attachmentSide];
            if (attachedNeighborStateCheck == null) {
                neighborStates[attachmentSide] = attachedNeighborState = world.getBlockState((BlockPos)mutaPos);
            } else {
                attachedNeighborState = attachedNeighborStateCheck;
            }
            int weakNeighborPower = attachedNeighborState.getSignal((BlockGetter)world, (BlockPos)mutaPos, attachmentDirection);
            int neighborPower = this.useIndirectPower && attachedNeighborState.shouldCheckWeakPower((SignalGetter)world, (BlockPos)mutaPos, attachmentDirection) ? Math.max(weakNeighborPower, world.getDirectSignalTo((BlockPos)mutaPos)) : weakNeighborPower;
            power = Math.max(power, neighborPower * 2 - 1);
            for (int orthagonal = 0; orthagonal < 4; ++orthagonal) {
                BlockEntity diagonalTe;
                BlockState neighborState;
                int neighborSide = DirectionHelper.uncompressSecondSide(attachmentSide, orthagonal);
                Direction directionToNeighbor = Direction.from3DDataValue((int)neighborSide);
                Direction directionToWire = directionToNeighbor.getOpposite();
                BlockState neighborStateCheck = neighborStates[neighborSide];
                mutaPos.setWithOffset((Vec3i)wirePos, directionToNeighbor);
                if (neighborStateCheck == null) {
                    neighborStates[neighborSide] = neighborState = world.getBlockState((BlockPos)mutaPos);
                } else {
                    neighborState = neighborStateCheck;
                }
                Block neighborBlock = neighborState.getBlock();
                WireConnector connector = connectors.getOrDefault(neighborBlock, defaultConnector);
                if (connector.canConnectToAdjacentWire((BlockGetter)world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToWire)) {
                    ExpandedPowerSupplier expandedPowerSupplier = expandedPowerSuppliers.getOrDefault(neighborBlock, defaultPowerSupplier);
                    int expandedWeakNeighborPower = expandedPowerSupplier.getExpandedPower(world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToNeighbor);
                    int expandedNeighborPower = this.useIndirectPower && neighborState.shouldCheckWeakPower((SignalGetter)world, (BlockPos)mutaPos, directionToNeighbor) ? Math.max(expandedWeakNeighborPower, world.getDirectSignalTo((BlockPos)mutaPos) * 2) : expandedWeakNeighborPower;
                    power = Math.max(power, expandedNeighborPower - 1);
                }
                if (directionToNeighbor != attachmentDirection) {
                    power = Math.max(power, wire.getPower(neighborSide) - 1);
                }
                if (attachedFaceStates[neighborSide] || neighborBlock != this || ((Boolean)neighborState.getValue((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) continue;
                BlockPos.MutableBlockPos diagonalPos = mutaPos.move(attachmentDirection);
                BlockState diagonalState = world.getBlockState((BlockPos)mutaPos);
                int directionToWireSide = directionToWire.ordinal();
                if (diagonalState.getBlock() != this || !((Boolean)diagonalState.getValue((Property)INTERIOR_FACES[directionToWireSide])).booleanValue() || !((diagonalTe = world.getBlockEntity((BlockPos)diagonalPos)) instanceof WireBlockEntity)) continue;
                power = Math.max(power, ((WireBlockEntity)diagonalTe).getPower(directionToWireSide) - 1);
            }
            if (!wire.setPower(attachmentSide, power)) continue;
            anyPowerUpdated = true;
            Direction[] nextUpdateDirs = BlockStateUtil.OUTPUT_TABLE[attachmentSide];
            for (int i = 0; i < 4; ++i) {
                Direction nextUpdateDir = nextUpdateDirs[i];
                if (!attachedFaceStates[nextUpdateDir.ordinal()]) continue;
                facesNeedingUpdates.add(nextUpdateDir);
            }
        }
        if (anyPowerUpdated && !world.isClientSide) {
            this.notifyNeighbors(world, wirePos, wireState, EnumSet.allOf(Direction.class), true);
        }
    }

    @Override
    protected void notifyNeighbors(Level world, BlockPos wirePos, BlockState newState, EnumSet<Direction> updateDirections, boolean doConductedPowerUpdates) {
        Block newBlock = newState.getBlock();
        if (!EventHooks.onNeighborNotify((Level)world, (BlockPos)wirePos, (BlockState)newState, updateDirections, (boolean)false).isCanceled()) {
            for (Direction dir : updateDirections) {
                BlockPos neighborPos = wirePos.relative(dir);
                boolean doSecondaryNeighborUpdates = doConductedPowerUpdates && world.getBlockState(neighborPos).shouldCheckWeakPower((SignalGetter)world, neighborPos, dir);
                world.neighborChanged(neighborPos, newBlock, wirePos);
                if (!doSecondaryNeighborUpdates) continue;
                world.updateNeighborsAt(neighborPos, newBlock);
            }
        }
    }
}

