/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client;

import com.tristankechlo.livingthings.client.ModelLayer;
import com.tristankechlo.livingthings.client.SimpleEntityRenderer;
import com.tristankechlo.livingthings.client.model.entity.ElephantModel;
import com.tristankechlo.livingthings.client.model.entity.FlamingoModel;
import com.tristankechlo.livingthings.client.model.entity.KoalaModel;
import com.tristankechlo.livingthings.client.model.entity.OstrichModel;
import com.tristankechlo.livingthings.client.model.entity.PeacockModel;
import com.tristankechlo.livingthings.client.model.entity.RaccoonModel;
import com.tristankechlo.livingthings.client.model.entity.SharkModel;
import com.tristankechlo.livingthings.entity.ElephantEntity;
import com.tristankechlo.livingthings.entity.FlamingoEntity;
import com.tristankechlo.livingthings.entity.KoalaEntity;
import com.tristankechlo.livingthings.entity.OstrichEntity;
import com.tristankechlo.livingthings.entity.PeacockEntity;
import com.tristankechlo.livingthings.entity.RaccoonEntity;
import com.tristankechlo.livingthings.entity.SharkEntity;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public final class LivingThingsClient {
    private static final ResourceLocation ELEPHANT_TEXTURE = LivingThingsClient.getEntityTexture("elephant/elephant.png");
    private static final ResourceLocation FLAMINGO_TEXTURE = LivingThingsClient.getEntityTexture("flamingo/flamingo.png");
    private static final ResourceLocation KOALA_TEXTURE = LivingThingsClient.getEntityTexture("koala/koala.png");
    private static final ResourceLocation OSTRICH_TEXTURE = LivingThingsClient.getEntityTexture("ostrich/ostrich.png");
    private static final ResourceLocation RACCOON_TEXTURE = LivingThingsClient.getEntityTexture("raccoon/raccoon.png");
    private static final ResourceLocation SHARK_TEXTURE = LivingThingsClient.getEntityTexture("shark/shark.png");
    private static final ResourceLocation PEACOCK_TEXTURE = LivingThingsClient.getEntityTexture("peacock/peacock.png");
    public static final EntityRendererProvider<ElephantEntity> ELEPHANT_RENDERER = context -> new SimpleEntityRenderer(context, 1.2f, ELEPHANT_TEXTURE, ModelLayer.ELEPHANT, ElephantModel::new);
    public static final EntityRendererProvider<FlamingoEntity> FLAMINGO_RENDERER = context -> new SimpleEntityRenderer(context, 0.35f, FLAMINGO_TEXTURE, ModelLayer.FLAMINGO, FlamingoModel::new);
    public static final EntityRendererProvider<KoalaEntity> KOALA_RENDERER = context -> new SimpleEntityRenderer(context, 0.4f, KOALA_TEXTURE, ModelLayer.KOALA, KoalaModel::new);
    public static final EntityRendererProvider<OstrichEntity> OSTRICH_RENDERER = context -> new SimpleEntityRenderer(context, 0.45f, OSTRICH_TEXTURE, ModelLayer.OSTRICH, OstrichModel::new);
    public static final EntityRendererProvider<RaccoonEntity> RACCOON_RENDERER = context -> new SimpleEntityRenderer(context, 0.4f, RACCOON_TEXTURE, ModelLayer.RACCOON, RaccoonModel::new);
    public static final EntityRendererProvider<SharkEntity> SHARK_RENDERER = context -> new SimpleEntityRenderer(context, 0.8f, SHARK_TEXTURE, ModelLayer.SHARK, SharkModel::new);
    public static final EntityRendererProvider<PeacockEntity> PEACOCK_RENDERER = context -> new SimpleEntityRenderer(context, 0.3f, PEACOCK_TEXTURE, ModelLayer.PEACOCK, PeacockModel::new);

    public static ResourceLocation getEntityTexture(String texture) {
        return ResourceLocation.fromNamespaceAndPath((String)"livingthings", (String)("textures/entity/" + texture));
    }
}

