/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.GiraffeEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GiraffeModel<T extends GiraffeEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart Legs;
    private final ModelPart NeckTop;
    private final ModelPart NeckMiddle;
    private final ModelPart NeckBottom;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart TailTop;
    private final ModelPart TailBottom;

    public GiraffeModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Legs = this.Body.getChild("Legs");
        this.NeckBottom = this.Body.getChild("NeckBottom");
        this.NeckMiddle = this.NeckBottom.getChild("NeckMiddle");
        this.NeckTop = this.NeckMiddle.getChild("NeckTop");
        this.Head = this.NeckTop.getChild("Head");
        this.FrontRightLeg = this.Legs.getChild("FrontRightLeg");
        this.FrontLeftLeg = this.Legs.getChild("FrontLeftLeg");
        this.BackRightLeg = this.Legs.getChild("BackRightLeg");
        this.BackLeftLeg = this.Legs.getChild("BackLeftLeg");
        this.TailTop = this.Body.getChild("TailTop");
        this.TailBottom = this.TailTop.getChild("TailBottom");
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        if (this.young) {
            matrixStackIn.scale(0.6f, 0.6f, 0.6f);
            matrixStackIn.translate(0.0f, 1.0f, 0.0f);
        }
        this.Body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setupAnim(GiraffeEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.NeckTop.xRot = this.NeckMiddle.xRot / 1.0f;
        this.NeckMiddle.xRot = this.Head.xRot / 2.0f;
        this.Head.yRot = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckTop.yRot = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckMiddle.yRot = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckBottom.yRot = netHeadYaw / 5.0f * ((float)Math.PI / 180);
        this.walk(this.FrontRightLeg, this.FrontLeftLeg, this.BackRightLeg, this.BackLeftLeg, limbSwing, limbSwingAmount);
        this.TailTop.zRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
        this.TailBottom.zRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(72, 35).addBox(-6.0f, -21.5f, -13.6f, 12.0f, 13.0f, 16.0f, new CubeDeformation(0.0f)).texOffs(81, 14).addBox(-5.5f, -19.5f, 2.4f, 11.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)14.5f, (float)0.6f));
        PartDefinition Legs = Body.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.5f, (float)-0.6f));
        PartDefinition FrontRightLeg = Legs.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(98, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(116, 0).addBox(-1.5f, 8.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-1.0f, (float)-10.0f));
        PartDefinition FrontLeftLeg = Legs.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(98, 0).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(116, 0).addBox(-1.5f, 8.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-1.0f, (float)-10.0f));
        PartDefinition BackLeftLeg = Legs.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(70, 0).mirror().addBox(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(116, 0).addBox(-1.5f, 10.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-3.0f, (float)10.0f));
        PartDefinition BackRightLeg = Legs.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(70, 0).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(116, 0).addBox(-1.5f, 10.0f, -1.5f, 3.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-3.0f, (float)10.0f));
        PartDefinition NeckBottom = Body.addOrReplaceChild("NeckBottom", CubeListBuilder.create().texOffs(0, 46).addBox(-4.5f, -2.0f, -3.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-21.5f, (float)-13.6f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition NeckMiddle = NeckBottom.addOrReplaceChild("NeckMiddle", CubeListBuilder.create().texOffs(0, 22).addBox(-3.5f, -10.0f, -3.5f, 7.0f, 11.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition NeckTop = NeckMiddle.addOrReplaceChild("NeckTop", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -10.0f, -2.5f, 5.0f, 11.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-10.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition Head = NeckTop.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(41, 52).addBox(-3.0f, -6.0f, -4.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition FrontHead = Head.addOrReplaceChild("FrontHead", CubeListBuilder.create().texOffs(46, 41).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition Horns = Head.addOrReplaceChild("Horns", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftHorn = Horns.addOrReplaceChild("LeftHorn", CubeListBuilder.create().texOffs(30, 15).addBox(0.5f, -2.5f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-6.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition RightHorn = Horns.addOrReplaceChild("RightHorn", CubeListBuilder.create().texOffs(30, 15).addBox(-0.5f, -2.5f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Ears = Head.addOrReplaceChild("Ears", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEar = Ears.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(36, 16).addBox(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-4.0f, (float)0.0f));
        PartDefinition RightEar = Ears.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(36, 16).addBox(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-4.0f, (float)0.0f));
        PartDefinition TailTop = Body.addOrReplaceChild("TailTop", CubeListBuilder.create().texOffs(48, 4).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 9.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-16.5f, (float)12.4f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition TailBottom = TailTop.addOrReplaceChild("TailBottom", CubeListBuilder.create().texOffs(53, 4).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)9.0f, (float)0.0f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

