/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.LionEntity;
import com.tristankechlo.livingthings.entity.misc.IGenderedMob;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class LionModel<T extends LionEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Mane;
    private final ModelPart Head;
    private final ModelPart Legs;
    private final ModelPart FrontRightLeg;
    private final ModelPart FrontLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart Tail;

    public LionModel(ModelPart root) {
        this.Body = root.getChild("Body");
        this.Mane = root.getChild("Mane");
        this.Head = this.Body.getChild("Head");
        this.Legs = this.Body.getChild("Legs");
        this.FrontRightLeg = this.Legs.getChild("FrontRightLeg");
        this.FrontLeftLeg = this.Legs.getChild("FrontLeftLeg");
        this.BackRightLeg = this.Legs.getChild("BackRightLeg");
        this.BackLeftLeg = this.Legs.getChild("BackLeftLeg");
        this.Tail = this.Body.getChild("Tail");
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        if (this.young) {
            matrixStackIn.scale(0.6f, 0.6f, 0.6f);
            matrixStackIn.translate(0.0f, 1.0f, 0.0f);
        } else {
            this.Mane.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
        }
        this.Body.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.walk(this.FrontRightLeg, this.FrontLeftLeg, this.BackRightLeg, this.BackLeftLeg, limbSwing, limbSwingAmount);
        this.Tail.zRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.75f * limbSwingAmount;
    }

    public void prepareMobModel(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.prepareMobModel(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.Mane.visible = ((LionEntity)entityIn).getGender() == IGenderedMob.Gender.MALE;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 23).addBox(-6.0f, -4.0f, -14.0f, 12.0f, 12.0f, 29.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)6.0f, (float)0.0f));
        PartDefinition Legs = Body.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition FrontLeftLeg = Legs.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(0, 17).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-10.0f, (float)-12.0f));
        PartDefinition FrontRightLeg = Legs.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(0, 17).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-10.0f, (float)-12.0f));
        PartDefinition BackLeftLeg = Legs.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(0, 17).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-10.0f, (float)12.0f));
        PartDefinition BackRightLeg = Legs.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(0, 17).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-10.0f, (float)12.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(61, 21).addBox(-1.0f, -12.5f, 0.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(59, 11).addBox(-2.0f, -15.5f, -1.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)14.5f, (float)-2.7489f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(88, 44).addBox(-6.0f, -7.0f, -8.0f, 12.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(30, 1).addBox(-3.0f, -2.0f, -14.0f, 6.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-14.0f));
        PartDefinition Ears = Head.addOrReplaceChild("Ears", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-7.0f, (float)-1.0f));
        PartDefinition LeftEar = Ears.addOrReplaceChild("LeftEar", CubeListBuilder.create().texOffs(11, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition RightEar = Ears.addOrReplaceChild("RightEar", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.0f, (float)0.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition Mane = partdefinition.addOrReplaceChild("Mane", CubeListBuilder.create().texOffs(82, 0).mirror().addBox(-7.0f, -9.0f, -2.0f, 14.0f, 15.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)6.0f, (float)-14.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }
}

