/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class SnailConfig
extends EntityConfig {
    private static final SnailConfig INSTANCE = new SnailConfig();
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 4.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.1, 0.0, 1024.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 6, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", SnailConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);

    private SnailConfig() {
        super("snail");
        this.registerConfigValues(this.health, this.movementSpeed, this.maxSpawnedInChunk, this.spawnBiomes);
    }

    public static SnailConfig get() {
        return INSTANCE;
    }

    public static double health() {
        return (Double)SnailConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)SnailConfig.INSTANCE.movementSpeed.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)SnailConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(12, 3, 5, new ResourceKey[]{Biomes.PLAINS, Biomes.SUNFLOWER_PLAINS, Biomes.SWAMP, Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.FLOWER_FOREST, Biomes.RIVER, Biomes.CHERRY_GROVE}), new SpawnData(10, 4, 6, new ResourceKey[]{Biomes.MUSHROOM_FIELDS}));
    }
}

