/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.common.item;

import cy.jdkdigital.utilitarian.module.UtilityItemModule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class TrowelItem
extends Item {
    public TrowelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        BlockPos pos;
        Level level = pContext.getLevel();
        BlockPos blockPos = pos = level.getBlockState(pContext.getClickedPos()).canBeReplaced() ? pContext.getClickedPos() : pContext.getClickedPos().relative(pContext.getClickedFace());
        if (pContext.getPlayer() != null) {
            boolean extended = TrowelItem.isExtended(pContext.getPlayer().getItemInHand(pContext.getHand()));
            HashMap<ItemStack, Integer> placeables = new HashMap<ItemStack, Integer>();
            int total = 0;
            for (int i = 0; i < (extended ? pContext.getPlayer().getInventory().getContainerSize() : 9); ++i) {
                ItemStack stack = pContext.getPlayer().getInventory().getItem(i);
                if (stack.is(UtilityItemModule.TROWEL_BLACKLIST) || !(stack.getItem() instanceof BlockItem)) continue;
                total += stack.getCount();
                placeables.put(stack, stack.getCount());
            }
            if (!placeables.isEmpty()) {
                if (!level.isClientSide()) {
                    BlockItem blockItem;
                    InteractionResult interactionResult;
                    Item item;
                    ItemStack randomItem = ItemStack.EMPTY;
                    int randomWeight = level.getRandom().nextInt(total);
                    for (Map.Entry entry : placeables.entrySet()) {
                        if ((randomWeight -= ((Integer)entry.getValue()).intValue()) > 0) continue;
                        randomItem = (ItemStack)entry.getKey();
                        break;
                    }
                    if (!randomItem.isEmpty() && (item = randomItem.getItem()) instanceof BlockItem && (interactionResult = (blockItem = (BlockItem)item).place(new BlockPlaceContext(level, pContext.getPlayer(), pContext.getHand(), randomItem, new BlockHitResult(pContext.getClickLocation(), pContext.getPlayer().getDirection(), pos, false)))).consumesAction()) {
                        BlockState blockState = blockItem.getBlock().defaultBlockState();
                        SoundType soundtype = blockState.getSoundType((LevelReader)level, pos, (Entity)pContext.getPlayer());
                        level.playSound(null, pos, blockState.getSoundType((LevelReader)level, pos, (Entity)pContext.getPlayer()).getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    }
                }
                return InteractionResult.SUCCESS_NO_ITEM_USED;
            }
        }
        return super.useOn(pContext);
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pPlayer.isShiftKeyDown()) {
            this.toggleState(pPlayer.getItemInHand(pUsedHand));
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        boolean extended = TrowelItem.isExtended(pStack);
        pTooltipComponents.add((Component)Component.translatable((String)"utilitarian.trowel.state", (Object[])new Object[]{Component.translatable((String)("utilitarian.trowel.state." + (extended ? "extended" : "normal"))).getString()}).withStyle(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.translatable((String)"utilitarian.trowel.tooltip").withStyle(ChatFormatting.GREEN));
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
    }

    private void toggleState(ItemStack pStack) {
        boolean extended = TrowelItem.isExtended(pStack);
        if (!extended) {
            pStack.set(UtilityItemModule.TROWEL_STATE, (Object)true);
        } else {
            pStack.set(UtilityItemModule.TROWEL_STATE, (Object)false);
        }
    }

    public static boolean isExtended(ItemStack pStack) {
        return (Boolean)pStack.getOrDefault(UtilityItemModule.TROWEL_STATE, (Object)false);
    }
}

