/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.event;

import cy.jdkdigital.utilitarian.client.render.block.NoSolicitingBannerRenderer;
import cy.jdkdigital.utilitarian.common.item.RestrainingOrder;
import cy.jdkdigital.utilitarian.common.item.TrowelItem;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import cy.jdkdigital.utilitarian.module.SnadModule;
import cy.jdkdigital.utilitarian.module.UtilityItemModule;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="utilitarian", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)NoSolicitingModule.NO_SOLICITING_BANNER_BLOCK_ENTITY.get(), NoSolicitingBannerRenderer::new);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)NoSolicitingModule.RESTRAINING_ORDER.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"active"), (stack, world, entity, i) -> RestrainingOrder.isActive(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UtilityItemModule.TROWEL.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"extended"), (stack, world, entity, i) -> TrowelItem.isExtended(stack) ? 1.0f : 0.0f);
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)SnadModule.GRRASS_BLOCK.get()), (RenderType)RenderType.cutoutMipped());
        });
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return event.getBlockColors().getColor(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)SnadModule.GRRASS_BLOCK.get()});
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)lightReader, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)SnadModule.GRRASS_BLOCK.get()});
    }
}

