/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gametest.content;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.screens.AccessibilityOnboardingScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GlobalTestReporter;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterGameTestsEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.embeddedt.embeddium.impl.gametest.content.NotAnAirBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestBlock;
import org.embeddedt.embeddium.impl.gametest.content.TestBlockEntity;
import org.embeddedt.embeddium.impl.gametest.content.client.InstrumentingModelWrapper;
import org.embeddedt.embeddium.impl.gametest.content.client.TestModel;
import org.embeddedt.embeddium.impl.gametest.network.SyncS2CPacket;
import org.embeddedt.embeddium.impl.gametest.tests.EmbeddiumGameTests;
import org.embeddedt.embeddium.impl.gametest.util.TestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegistry {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Embeddium/TestSystem");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"embeddium");
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"embeddium");
    public static final DeferredHolder<Block, TestBlock> TEST_BLOCK = BLOCKS.register("test_block", TestBlock::new);
    public static final DeferredHolder<Block, NotAnAirBlock> NOT_AN_AIR_BLOCK = BLOCKS.register("not_an_air_block", NotAnAirBlock::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> TEST_BLOCK_ENTITY = BLOCK_ENTITIES.register("test_block_entity", () -> BlockEntityType.Builder.of(TestBlockEntity::new, (Block[])new Block[]{(Block)TEST_BLOCK.get()}).build(null));
    public static final ResourceLocation EMPTY_TEMPLATE = ResourceLocation.fromNamespaceAndPath((String)"embeddium", (String)"empty_structure");
    public static final String EMPTY_TEMPLATE_STR = EMPTY_TEMPLATE.toString();
    public static final boolean IS_AUTOMATED_TEST_RUN = Boolean.getBoolean("embeddium.runAutomatedTests");

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        IEventBus bus = ModLoadingContext.get().getActiveContainer().getEventBus();
        BLOCKS.register(bus);
        BLOCK_ENTITIES.register(bus);
        NeoForge.EVENT_BUS.register(GameEvents.class);
    }

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(SyncS2CPacket.TYPE, SyncS2CPacket.STREAM_CODEC, SyncS2CPacket::handle);
    }

    private static void registerModelForAllStates(ModelEvent.ModifyBakingResult event, Block block, BakedModel model) {
        for (BlockState state : block.getStateDefinition().getPossibleStates()) {
            event.getModels().put(BlockModelShaper.stateToModelLocation((BlockState)state), model);
        }
    }

    @SubscribeEvent
    public static void onBakingModify(ModelEvent.ModifyBakingResult event) {
        TestRegistry.registerModelForAllStates(event, (Block)TEST_BLOCK.get(), (BakedModel)new TestModel((BakedModel)event.getModels().get(ModelBakery.MISSING_MODEL_VARIANT)));
        TestRegistry.registerModelForAllStates(event, (Block)NOT_AN_AIR_BLOCK.get(), new InstrumentingModelWrapper<BakedModel>((BakedModel)event.getModels().get(BlockModelShaper.stateToModelLocation((BlockState)Blocks.STONE.defaultBlockState()))));
    }

    private static void testRunner(GameTestHelper helper, Method testMethod) {
        try {
            testMethod.invoke(null, helper);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)throwable;
                throw re;
            }
            throw new RuntimeException("Error running test", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error invoking method", e);
        }
        finally {
            TestUtils.movePlayerToPosition(helper, new BlockPos(4, 12, 4));
            TestUtils.waitForTestAreaToLoad(helper);
            TestUtils.obtainScreenshot(testMethod.getName());
        }
    }

    @SubscribeEvent
    public static void createGameTests(RegisterGameTestsEvent event) {
        Collection functions = (Collection)ObfuscationReflectionHelper.getPrivateValue(GameTestRegistry.class, null, (String)"TEST_FUNCTIONS");
        Set classNames = (Set)ObfuscationReflectionHelper.getPrivateValue(GameTestRegistry.class, null, (String)"TEST_CLASS_NAMES");
        classNames.add(EmbeddiumGameTests.class.getSimpleName());
        for (Method m : EmbeddiumGameTests.class.getDeclaredMethods()) {
            GameTest gametest = m.getAnnotation(GameTest.class);
            if (gametest == null) continue;
            functions.add(new TestFunction(gametest.batch(), m.getName(), EMPTY_TEMPLATE_STR, Rotation.NONE, gametest.timeoutTicks(), gametest.setupTicks(), gametest.required(), gametest.manualOnly(), gametest.requiredSuccesses(), gametest.attempts(), gametest.skyAccess(), helper -> TestRegistry.testRunner(helper, m)));
        }
    }

    static class GameEvents {
        private static boolean hasSeenMainMenu = false;
        private static final Set<ResourceLocation> HIDDEN_OVERLAYS = Set.of(VanillaGuiLayers.CHAT, VanillaGuiLayers.CAMERA_OVERLAYS);
        private static WeakReference<Screen> nextOpeningScreen;
        private static final Semaphore LATCH;
        private static MultipleTestTracker testTracker;

        GameEvents() {
        }

        @SubscribeEvent
        public static void createEmptyTemplate(ServerAboutToStartEvent event) {
            StructureTemplateManager structureManager = event.getServer().getStructureManager();
            StructureTemplate template = structureManager.getOrCreate(EMPTY_TEMPLATE);
            ObfuscationReflectionHelper.setPrivateValue(StructureTemplate.class, (Object)template, (Object)new Vec3i(9, 9, 9), (String)"size");
            template.setAuthor("Embeddium");
        }

        @SubscribeEvent
        public static void onScreenInit(ScreenEvent.Init.Post event) {
            if (IS_AUTOMATED_TEST_RUN && (event.getScreen() instanceof TitleScreen || event.getScreen() instanceof AccessibilityOnboardingScreen) && !hasSeenMainMenu) {
                hasSeenMainMenu = true;
                Minecraft mc = Minecraft.getInstance();
                DebugScreenOverlay debugOverlay = mc.gui.getDebugOverlay();
                debugOverlay.reset();
                debugOverlay.toggleOverlay();
                GenericMessageScreen messageScreen = new GenericMessageScreen((Component)Component.literal((String)"Bootstrapping gametests..."));
                mc.forceSetScreen((Screen)messageScreen);
                String levelName = "embeddium-test-" + String.valueOf(UUID.randomUUID());
                LevelSettings settings = new LevelSettings(levelName, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, new GameRules(), WorldDataConfiguration.DEFAULT);
                mc.createWorldOpenFlows().createFreshLevel(settings.levelName(), settings, new WorldOptions(1024L, false, false), registry -> ((WorldPreset)registry.registryOrThrow(Registries.WORLD_PRESET).getHolderOrThrow(WorldPresets.FLAT).value()).createWorldDimensions(), (Screen)messageScreen);
            }
        }

        @SubscribeEvent
        public static void hideGuiLayers(RenderGuiLayerEvent.Pre event) {
            if (IS_AUTOMATED_TEST_RUN && HIDDEN_OVERLAYS.contains(event.getName())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onScreenOpen(ScreenEvent.Opening event) {
            if (IS_AUTOMATED_TEST_RUN && event.getScreen() instanceof PauseScreen && !Minecraft.getInstance().isWindowActive()) {
                event.setCanceled(true);
                return;
            }
            nextOpeningScreen = new WeakReference<Screen>(event.getScreen());
        }

        @SubscribeEvent
        public static void onScreenChange(ScreenEvent.Closing event) {
            if (IS_AUTOMATED_TEST_RUN && !(nextOpeningScreen.get() instanceof ReceivingLevelScreen) && event.getScreen() instanceof ReceivingLevelScreen) {
                LATCH.release();
            }
            nextOpeningScreen = new WeakReference<Object>(null);
        }

        @SubscribeEvent
        public static void onServerTick(ServerTickEvent.Pre event) {
            if (LATCH.tryAcquire()) {
                ServerLevel level = event.getServer().overworld();
                GameTestRunner runner = GameTestRunner.Builder.fromBatches((Collection)GameTestBatchFactory.fromTestFunction((Collection)GameTestRegistry.getAllTestFunctions(), (ServerLevel)level), (ServerLevel)level).newStructureSpawner((GameTestRunner.StructureSpawner)new StructureGridSpawner(new BlockPos(0, -60, 0), 8, false)).build();
                runner.start();
                testTracker = new MultipleTestTracker((Collection)runner.getTestInfos());
            } else if (testTracker != null) {
                if (testTracker.isDone()) {
                    int exitCode;
                    LOGGER.info(testTracker.getProgressBar());
                    GlobalTestReporter.finish();
                    LOGGER.info("Completed {} tests", (Object)testTracker.getTotalCount());
                    if (testTracker.hasFailedRequired()) {
                        testTracker.getFailedRequired().forEach(info -> LOGGER.info("Test {} failed", (Object)info.getTestName(), (Object)info.getError()));
                        exitCode = 1;
                    } else {
                        exitCode = 0;
                    }
                    Minecraft.getInstance().execute(() -> System.exit(exitCode));
                    testTracker = null;
                } else if (event.getServer().overworld().getGameTime() % 20L == 0L) {
                    LOGGER.info(testTracker.getProgressBar());
                }
            }
        }

        static {
            LATCH = new Semaphore(0);
        }
    }
}

