/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.gui.console;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.embeddedt.embeddium.api.util.ColorARGB;
import org.embeddedt.embeddium.api.util.ColorU8;
import org.embeddedt.embeddium.impl.gui.console.Console;
import org.embeddedt.embeddium.impl.gui.console.message.Message;
import org.embeddedt.embeddium.impl.gui.console.message.MessageLevel;
import org.lwjgl.glfw.GLFW;

public class ConsoleRenderer {
    static final ConsoleRenderer INSTANCE = new ConsoleRenderer();
    private final LinkedList<ActiveMessage> activeMessages = new LinkedList();
    private static final EnumMap<MessageLevel, ColorPalette> COLORS = new EnumMap(MessageLevel.class);

    public void update(Console console, double currentTime) {
        this.purgeMessages(currentTime);
        this.pollMessages(console, currentTime);
    }

    private void purgeMessages(double currentTime) {
        this.activeMessages.removeIf(message -> currentTime > message.timestamp() + message.duration());
    }

    private void pollMessages(Console console, double currentTime) {
        Deque<Message> log = console.getMessageDrain();
        while (!log.isEmpty()) {
            this.activeMessages.add(ActiveMessage.create(log.poll(), currentTime));
        }
    }

    public void draw(GuiGraphics context) {
        double currentTime = GLFW.glfwGetTime();
        Minecraft client = Minecraft.getInstance();
        PoseStack matrices = context.pose();
        matrices.pushPose();
        matrices.translate(0.0f, 0.0f, 1000.0f);
        int paddingWidth = 3;
        int paddingHeight = 1;
        ArrayList<MessageRender> renders = new ArrayList<MessageRender>();
        int x = 4;
        int y = 4;
        for (ActiveMessage message : this.activeMessages) {
            double opacity = ConsoleRenderer.getMessageOpacity(message, currentTime);
            if (opacity < 0.025) continue;
            ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
            int messageWidth = 270;
            StringSplitter textHandler = client.font.getSplitter();
            textHandler.splitLines((FormattedText)message.text(), messageWidth - 20, Style.EMPTY, (text, lastLineWrapped) -> lines.add(Language.getInstance().getVisualOrder(text)));
            Objects.requireNonNull(client.font);
            int messageHeight = 9 * lines.size() + paddingHeight * 2;
            renders.add(new MessageRender(x, y, messageWidth, messageHeight, message.level(), lines, opacity));
            y += messageHeight;
        }
        double mouseX = client.mouseHandler.xpos() / client.getWindow().getGuiScale();
        double mouseY = client.mouseHandler.ypos() / client.getWindow().getGuiScale();
        boolean hovered = false;
        for (MessageRender render : renders) {
            if (!(mouseX >= (double)render.x) || !(mouseX < (double)(render.x + render.width)) || !(mouseY >= (double)render.y) || !(mouseY < (double)(render.y + render.height))) continue;
            hovered = true;
            break;
        }
        for (MessageRender render : renders) {
            int x2 = render.x();
            int y2 = render.y();
            int width = render.width();
            int height = render.height();
            ColorPalette colors = COLORS.get((Object)render.level());
            double opacity = render.opacity();
            if (hovered) {
                opacity *= 0.4;
            }
            context.fill(x2, y2, x2 + width, y2 + height, ColorARGB.withAlpha(colors.background(), ConsoleRenderer.weightAlpha(opacity)));
            context.fill(x2, y2, x2 + 1, y2 + height, ColorARGB.withAlpha(colors.foreground(), ConsoleRenderer.weightAlpha(opacity)));
            for (FormattedCharSequence line : render.lines()) {
                context.drawString(client.font, line, x2 + paddingWidth + 3, y2 + paddingHeight, ColorARGB.withAlpha(colors.text(), ConsoleRenderer.weightAlpha(opacity)), false);
                Objects.requireNonNull(client.font);
                y2 += 9;
            }
        }
        matrices.popPose();
    }

    private static double getMessageOpacity(ActiveMessage message, double time) {
        double midpoint = message.timestamp() + message.duration() / 2.0;
        if (time > midpoint) {
            return ConsoleRenderer.getFadeOutOpacity(message, time);
        }
        if (time < midpoint) {
            return ConsoleRenderer.getFadeInOpacity(message, time);
        }
        return 1.0;
    }

    private static double getFadeInOpacity(ActiveMessage message, double time) {
        double animationDuration = 0.25;
        double animationStart = message.timestamp();
        double animationEnd = message.timestamp() + animationDuration;
        return ConsoleRenderer.getAnimationProgress(time, animationStart, animationEnd);
    }

    private static double getFadeOutOpacity(ActiveMessage message, double time) {
        double animationDuration = Math.min(0.5, message.duration() * 0.2);
        double animationStart = message.timestamp() + message.duration() - animationDuration;
        double animationEnd = message.timestamp() + message.duration();
        return 1.0 - ConsoleRenderer.getAnimationProgress(time, animationStart, animationEnd);
    }

    private static double getAnimationProgress(double currentTime, double startTime, double endTime) {
        return Mth.clamp((double)Mth.inverseLerp((double)currentTime, (double)startTime, (double)endTime), (double)0.0, (double)1.0);
    }

    private static int weightAlpha(double scale) {
        return ColorU8.normalizedFloatToByte((float)scale);
    }

    static {
        COLORS.put(MessageLevel.INFO, new ColorPalette(ColorARGB.pack(255, 255, 255), ColorARGB.pack(15, 15, 15), ColorARGB.pack(15, 15, 15)));
        COLORS.put(MessageLevel.WARN, new ColorPalette(ColorARGB.pack(224, 187, 0), ColorARGB.pack(25, 21, 0), ColorARGB.pack(180, 150, 0)));
        COLORS.put(MessageLevel.SEVERE, new ColorPalette(ColorARGB.pack(220, 0, 0), ColorARGB.pack(25, 0, 0), ColorARGB.pack(160, 0, 0)));
    }

    private record ActiveMessage(MessageLevel level, Component text, double duration, double timestamp) {
        public static ActiveMessage create(Message message, double timestamp) {
            MutableComponent text = message.text().copy().withStyle(style -> style.withFont(Minecraft.UNIFORM_FONT));
            return new ActiveMessage(message.level(), (Component)text, message.duration(), timestamp);
        }
    }

    private record MessageRender(int x, int y, int width, int height, MessageLevel level, List<FormattedCharSequence> lines, double opacity) {
    }

    private record ColorPalette(int text, int background, int foreground) {
    }
}

