/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.impl.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.nio.ByteBuffer;
import java.util.Map;
import org.embeddedt.embeddium.impl.render.chunk.RenderSection;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBufferSorter;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildContext;
import org.embeddedt.embeddium.impl.render.chunk.compile.ChunkBuildOutput;
import org.embeddedt.embeddium.impl.render.chunk.compile.tasks.ChunkBuilderTask;
import org.embeddedt.embeddium.impl.render.chunk.data.BuiltSectionMeshParts;
import org.embeddedt.embeddium.impl.render.chunk.sorting.TranslucentQuadAnalyzer;
import org.embeddedt.embeddium.impl.render.chunk.terrain.TerrainRenderPass;
import org.embeddedt.embeddium.impl.util.NativeBuffer;
import org.embeddedt.embeddium.impl.util.task.CancellationToken;

public class ChunkBuilderSortTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final RenderSection render;
    private final float cameraX;
    private final float cameraY;
    private final float cameraZ;
    private final int frame;
    private final Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> translucentMeshes;

    public ChunkBuilderSortTask(RenderSection render, float cameraX, float cameraY, float cameraZ, int frame, Map<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> translucentMeshes) {
        this.render = render;
        this.cameraX = cameraX;
        this.cameraY = cameraY;
        this.cameraZ = cameraZ;
        this.frame = frame;
        this.translucentMeshes = translucentMeshes;
    }

    private static NativeBuffer makeNativeBuffer(ByteBuffer heapBuffer) {
        heapBuffer.rewind();
        NativeBuffer nb = new NativeBuffer(heapBuffer.capacity());
        nb.getDirectBuffer().put(heapBuffer);
        return nb;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext context, CancellationToken cancellationSource) {
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        for (Map.Entry<TerrainRenderPass, TranslucentQuadAnalyzer.SortState> entry : this.translucentMeshes.entrySet()) {
            TranslucentQuadAnalyzer.SortState sortBuffer = entry.getValue();
            NativeBuffer newIndexBuffer = new NativeBuffer(ChunkBufferSorter.getIndexBufferSize(sortBuffer.centers().length / 3));
            ChunkBufferSorter.sort(newIndexBuffer, sortBuffer, this.cameraX - (float)this.render.getOriginX(), this.cameraY - (float)this.render.getOriginY(), this.cameraZ - (float)this.render.getOriginZ());
            meshes.put(entry.getKey(), new BuiltSectionMeshParts(null, newIndexBuffer, sortBuffer, null));
        }
        ChunkBuildOutput result = new ChunkBuildOutput(this.render, null, (Map<TerrainRenderPass, BuiltSectionMeshParts>)meshes, this.frame);
        result.setIndexOnlyUpload(true);
        return result;
    }
}

