/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.BasicActivatingRecipe;
import mekanism.api.recipes.basic.BasicCentrifugingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;

@NothingNullByDefault
public class ChemicalToChemicalRecipeBuilder
extends MekanismRecipeBuilder<ChemicalToChemicalRecipeBuilder> {
    private final Factory factory;
    private final ChemicalStackIngredient input;
    private final ChemicalStack output;

    protected ChemicalToChemicalRecipeBuilder(ChemicalStackIngredient input, ChemicalStack output, Factory factory) {
        this.input = input;
        this.output = output;
        this.factory = factory;
    }

    public static ChemicalToChemicalRecipeBuilder activating(ChemicalStackIngredient input, ChemicalStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This solar neutron activator recipe requires a non empty chemical output.");
        }
        return new ChemicalToChemicalRecipeBuilder(input, output, BasicActivatingRecipe::new);
    }

    public static ChemicalToChemicalRecipeBuilder centrifuging(ChemicalStackIngredient input, ChemicalStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This Isotopic Centrifuge recipe requires a non empty chemical output.");
        }
        return new ChemicalToChemicalRecipeBuilder(input, output, BasicCentrifugingRecipe::new);
    }

    protected ChemicalToChemicalRecipe asRecipe() {
        return this.factory.create(this.input, this.output);
    }

    @FunctionalInterface
    public static interface Factory {
        public ChemicalToChemicalRecipe create(ChemicalStackIngredient var1, ChemicalStack var2);
    }
}

