/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.heat;

import mekanism.api.annotations.NothingNullByDefault;

@NothingNullByDefault
public interface IHeatHandler {
    public int getHeatCapacitorCount();

    public double getTemperature(int var1);

    public double getInverseConduction(int var1);

    public double getHeatCapacity(int var1);

    public void handleHeat(int var1, double var2);

    default public double getTotalTemperature() {
        int heatCapacitorCount = this.getHeatCapacitorCount();
        if (heatCapacitorCount == 1) {
            return this.getTemperature(0);
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity();
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.getTemperature(capacitor) * (this.getHeatCapacity(capacitor) / totalCapacity);
        }
        return sum;
    }

    default public double getTotalInverseConduction() {
        int heatCapacitorCount = this.getHeatCapacitorCount();
        if (heatCapacitorCount == 0) {
            return 1.0;
        }
        if (heatCapacitorCount == 1) {
            return this.getInverseConduction(0);
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity();
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.getInverseConduction(capacitor) * (this.getHeatCapacity(capacitor) / totalCapacity);
        }
        return sum;
    }

    default public double getTotalHeatCapacity() {
        int heatCapacitorCount = this.getHeatCapacitorCount();
        if (heatCapacitorCount == 1) {
            return this.getHeatCapacity(0);
        }
        double sum = 0.0;
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.getHeatCapacity(capacitor);
        }
        return sum;
    }

    default public void handleHeat(double transfer) {
        int heatCapacitorCount = this.getHeatCapacitorCount();
        if (heatCapacitorCount == 1) {
            this.handleHeat(0, transfer);
        } else {
            double totalHeatCapacity = this.getTotalHeatCapacity();
            for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
                this.handleHeat(capacitor, transfer * (this.getHeatCapacity(capacitor) / totalHeatCapacity));
            }
        }
    }
}

