/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class BasicChemicalChemicalToChemicalRecipe
extends ChemicalChemicalToChemicalRecipe
implements IBasicChemicalOutput {
    private final RecipeType<ChemicalChemicalToChemicalRecipe> recipeType;
    protected final ChemicalStackIngredient leftInput;
    protected final ChemicalStackIngredient rightInput;
    protected final ChemicalStack output;

    public BasicChemicalChemicalToChemicalRecipe(ChemicalStackIngredient leftInput, ChemicalStackIngredient rightInput, ChemicalStack output, RecipeType<ChemicalChemicalToChemicalRecipe> recipeType) {
        this.recipeType = Objects.requireNonNull(recipeType, "Recipe type cannot be null");
        this.leftInput = Objects.requireNonNull(leftInput, "Left input cannot be null.");
        this.rightInput = Objects.requireNonNull(rightInput, "Right input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    public final RecipeType<ChemicalChemicalToChemicalRecipe> getType() {
        return this.recipeType;
    }

    @Override
    public boolean test(ChemicalStack input1, ChemicalStack input2) {
        return this.leftInput.test(input1) && this.rightInput.test(input2) || this.rightInput.test(input1) && this.leftInput.test(input2);
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public ChemicalStack getOutput(ChemicalStack input1, ChemicalStack input2) {
        return this.output.copy();
    }

    @Override
    public ChemicalStackIngredient getLeftInput() {
        return this.leftInput;
    }

    @Override
    public ChemicalStackIngredient getRightInput() {
        return this.rightInput;
    }

    @Override
    public List<ChemicalStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public ChemicalStack getOutputRaw() {
        return this.output;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicChemicalChemicalToChemicalRecipe other = (BasicChemicalChemicalToChemicalRecipe)o;
        return this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.output.equals(other.output);
    }

    public int hashCode() {
        int result = this.leftInput.hashCode();
        result = 31 * result + this.rightInput.hashCode();
        result = 31 * result + this.output.hashCode();
        return result;
    }
}

