/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalChemicalToChemicalCachedRecipe<RECIPE extends ChemicalChemicalToChemicalRecipe>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<ChemicalStack> outputHandler;
    private final IInputHandler<ChemicalStack> leftInputHandler;
    private final IInputHandler<ChemicalStack> rightInputHandler;
    private final BiConsumer<ChemicalStack, ChemicalStack> inputsSetter;
    private final Consumer<ChemicalStack> outputSetter;
    private final Supplier<ChemicalStackIngredient> leftInput;
    private final Supplier<ChemicalStackIngredient> rightInput;
    private final BinaryOperator<ChemicalStack> outputGetter;
    @Nullable
    private ChemicalStack leftRecipeInput;
    @Nullable
    private ChemicalStack rightRecipeInput;
    @Nullable
    private ChemicalStack output;

    public ChemicalChemicalToChemicalCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<ChemicalStack> leftInputHandler, IInputHandler<ChemicalStack> rightInputHandler, IOutputHandler<ChemicalStack> outputHandler) {
        super(recipe, recheckAllErrors);
        this.leftInputHandler = Objects.requireNonNull(leftInputHandler, "Left input handler cannot be null.");
        this.rightInputHandler = Objects.requireNonNull(rightInputHandler, "Right input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.leftInput = ((ChemicalChemicalToChemicalRecipe)this.recipe)::getLeftInput;
        this.rightInput = ((ChemicalChemicalToChemicalRecipe)this.recipe)::getRightInput;
        this.inputsSetter = (left, right) -> {
            this.leftRecipeInput = left;
            this.rightRecipeInput = right;
        };
        this.outputSetter = output -> {
            this.output = output;
        };
        this.outputGetter = ((ChemicalChemicalToChemicalRecipe)this.recipe)::getOutput;
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            ChemicalStack leftInputChemical = this.leftInputHandler.getInput();
            if (leftInputChemical.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                ChemicalStack rightInputChemical = this.rightInputHandler.getInput();
                if (rightInputChemical.isEmpty()) {
                    tracker.mismatchedRecipe();
                } else {
                    Supplier<ChemicalStackIngredient> rightIngredient;
                    Supplier<ChemicalStackIngredient> leftIngredient;
                    if (!((ChemicalChemicalToChemicalRecipe)this.recipe).getLeftInput().test(leftInputChemical) || !((ChemicalChemicalToChemicalRecipe)this.recipe).getRightInput().test(rightInputChemical)) {
                        leftIngredient = this.rightInput;
                        rightIngredient = this.leftInput;
                    } else {
                        leftIngredient = this.leftInput;
                        rightIngredient = this.rightInput;
                    }
                    CachedRecipeHelper.twoInputCalculateOperationsThisTick(tracker, this.leftInputHandler, leftIngredient, this.rightInputHandler, rightIngredient, this.inputsSetter, this.outputHandler, this.outputGetter, this.outputSetter, ConstantPredicates.CHEMICAL_EMPTY, ConstantPredicates.CHEMICAL_EMPTY);
                }
            }
        }
    }

    @Override
    public boolean isInputValid() {
        ChemicalStack leftInput = this.leftInputHandler.getInput();
        if (leftInput.isEmpty()) {
            return false;
        }
        ChemicalStack rightInput = this.rightInputHandler.getInput();
        return !rightInput.isEmpty() && ((ChemicalChemicalToChemicalRecipe)this.recipe).test(leftInput, rightInput);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (!(this.leftRecipeInput == null || this.rightRecipeInput == null || this.output == null || this.leftRecipeInput.isEmpty() || this.rightRecipeInput.isEmpty() || this.output.isEmpty())) {
            this.leftInputHandler.use(this.leftRecipeInput, operations);
            this.rightInputHandler.use(this.rightRecipeInput, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

