/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import mekanism.api.MekanismAPI;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.InputIngredient;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.TagFluidIngredient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class FluidStackIngredient
implements InputIngredient<FluidStack> {
    public static final Codec<FluidStackIngredient> CODEC = SizedFluidIngredient.FLAT_CODEC.xmap(FluidStackIngredient::new, FluidStackIngredient::ingredient);
    public static final StreamCodec<RegistryFriendlyByteBuf, FluidStackIngredient> STREAM_CODEC = SizedFluidIngredient.STREAM_CODEC.map(FluidStackIngredient::new, FluidStackIngredient::ingredient);
    private final SizedFluidIngredient ingredient;
    @Nullable
    private List<FluidStack> representations;

    public static FluidStackIngredient of(SizedFluidIngredient ingredient) {
        Objects.requireNonNull(ingredient, "FluidStackIngredients cannot be created from a null ingredient.");
        if (ingredient.ingredient().isEmpty()) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created using the empty ingredient.");
        }
        return new FluidStackIngredient(ingredient);
    }

    private FluidStackIngredient(SizedFluidIngredient ingredient) {
        this.ingredient = ingredient;
    }

    @Override
    public boolean test(FluidStack stack) {
        Objects.requireNonNull(stack);
        return this.ingredient.test(stack);
    }

    @Override
    public boolean testType(FluidStack stack) {
        Objects.requireNonNull(stack);
        return this.ingredient.ingredient().test(stack);
    }

    @Override
    public FluidStack getMatchingInstance(FluidStack stack) {
        return this.test(stack) ? stack.copyWithAmount(this.ingredient.amount()) : FluidStack.EMPTY;
    }

    @Override
    public long getNeededAmount(FluidStack stack) {
        return this.testType(stack) ? (long)this.ingredient.amount() : 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return this.ingredient.ingredient().hasNoFluids();
    }

    @Override
    public void logMissingTags() {
        if (this.hasNoMatchingInstances()) {
            FluidIngredient fluidIngredient = this.ingredient.ingredient();
            if (fluidIngredient instanceof TagFluidIngredient) {
                TagFluidIngredient tagged = (TagFluidIngredient)fluidIngredient;
                MekanismAPI.logger.error("Empty tag: {}", (Object)tagged.tag());
            } else {
                MekanismAPI.logger.error("Empty FluidStackIngredient: {}", (Object)SerializerHelper.stringify(FluidIngredient.CODEC, fluidIngredient));
            }
        }
    }

    @Override
    public List<@NotNull FluidStack> getRepresentations() {
        if (this.representations == null) {
            this.representations = List.of(this.ingredient.getFluids());
        }
        return this.representations;
    }

    @ApiStatus.Internal
    public SizedFluidIngredient ingredient() {
        return this.ingredient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.ingredient.equals((Object)((FluidStackIngredient)o).ingredient);
    }

    public int hashCode() {
        return this.ingredient.hashCode();
    }

    public String toString() {
        return this.ingredient.toString();
    }
}

