/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;

public class GuiGasMode
extends MekanismImageButton {
    private static final ResourceLocation IDLE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "gas_mode_idle.png");
    private static final ResourceLocation EXCESS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "gas_mode_excess.png");
    private static final ResourceLocation DUMP = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "gas_mode_dump.png");
    private final Tooltip dumpExcess;
    private final Tooltip dump;
    private final IFancyFontRenderer.TextAlignment textSide;
    private final Supplier<TileEntityChemicalTank.GasMode> gasModeSupplier;

    public GuiGasMode(IGuiWrapper gui, int x, int y, boolean left, Supplier<TileEntityChemicalTank.GasMode> gasModeSupplier, BlockPos pos, int tank) {
        this(gui, x, y, left, gasModeSupplier, pos, tank, null, null);
    }

    public GuiGasMode(IGuiWrapper gui, int x, int y, boolean left, Supplier<TileEntityChemicalTank.GasMode> gasModeSupplier, BlockPos pos, int tank, Tooltip dumpExcess, Tooltip dump) {
        super(gui, x, y, 10, IDLE, (GuiElement element, double mouseX, double mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.GAS_MODE_BUTTON, pos, tank)));
        this.textSide = left ? IFancyFontRenderer.TextAlignment.RIGHT : IFancyFontRenderer.TextAlignment.LEFT;
        this.gasModeSupplier = gasModeSupplier;
        this.dumpExcess = dumpExcess;
        this.dump = dump;
    }

    @Override
    protected ResourceLocation getResource() {
        return switch (this.gasModeSupplier.get()) {
            case TileEntityChemicalTank.GasMode.DUMPING_EXCESS -> EXCESS;
            case TileEntityChemicalTank.GasMode.DUMPING -> DUMP;
            default -> super.getResource();
        };
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int start = this.textSide == IFancyFontRenderer.TextAlignment.RIGHT ? -69 : this.getWidth();
        this.drawScrollingString(guiGraphics, this.gasModeSupplier.get().getTextComponent(), start, 1, this.textSide, this.titleTextColor(), 69, 2, false);
        super.renderForeground(guiGraphics, mouseX, mouseY);
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (this.dumpExcess != null) {
            TileEntityChemicalTank.GasMode dumpMode = this.gasModeSupplier.get();
            if (dumpMode != TileEntityChemicalTank.GasMode.IDLE) {
                this.setTooltip(dumpMode == TileEntityChemicalTank.GasMode.DUMPING_EXCESS ? this.dumpExcess : this.dump);
            } else {
                this.clearTooltip();
            }
        }
    }
}

