/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class MekanismImageButton
extends MekanismButton {
    private final ResourceLocation resourceLocation;
    private final int textureWidth;
    private final int textureHeight;

    public MekanismImageButton(IGuiWrapper gui, int x, int y, int size, ResourceLocation resource, @NotNull GuiElement.IClickable onPress) {
        this(gui, x, y, size, size, resource, onPress);
    }

    public MekanismImageButton(IGuiWrapper gui, int x, int y, int size, int textureSize, ResourceLocation resource, @NotNull GuiElement.IClickable onPress) {
        this(gui, x, y, size, size, textureSize, textureSize, resource, onPress);
    }

    public MekanismImageButton(IGuiWrapper gui, int x, int y, int width, int height, int textureWidth, int textureHeight, ResourceLocation resource, @NotNull GuiElement.IClickable onPress) {
        this(gui, x, y, width, height, textureWidth, textureHeight, resource, onPress, onPress);
    }

    public MekanismImageButton(IGuiWrapper gui, int x, int y, int width, int height, int textureWidth, int textureHeight, ResourceLocation resource, @NotNull GuiElement.IClickable onLeftClick, @NotNull GuiElement.IClickable onRightClick) {
        super(gui, x, y, width, height, CommonComponents.EMPTY, onLeftClick, onRightClick);
        this.resourceLocation = resource;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(this.getResource(), this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.textureWidth, this.textureHeight);
    }

    protected ResourceLocation getResource() {
        return this.resourceLocation;
    }
}

