/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.EnumMap;
import java.util.Map;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.gui.element.window.GuiSideConfiguration;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiConfigTypeTab
extends GuiInsetElement<Void> {
    private final Map<TransmissionType, Tooltip> typeTooltips = new EnumMap<TransmissionType, Tooltip>(TransmissionType.class);
    private final TransmissionType transmission;
    private final GuiSideConfiguration<?> config;

    public GuiConfigTypeTab(IGuiWrapper gui, TransmissionType type, int x, int y, GuiSideConfiguration<?> config, boolean left) {
        super(GuiConfigTypeTab.getResource(type), gui, null, x, y, 26, 18, left);
        this.config = config;
        this.transmission = type;
    }

    private static ResourceLocation getResource(TransmissionType t) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, t.getTransmission() + ".png");
    }

    public TransmissionType getTransmissionType() {
        return this.transmission;
    }

    @Override
    protected void colorTab(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, switch (this.transmission) {
            default -> throw new MatchException(null, null);
            case TransmissionType.ENERGY -> SpecialColors.TAB_ENERGY_CONFIG;
            case TransmissionType.FLUID -> SpecialColors.TAB_FLUID_CONFIG;
            case TransmissionType.CHEMICAL -> SpecialColors.TAB_CHEMICAL_CONFIG;
            case TransmissionType.ITEM -> SpecialColors.TAB_ITEM_CONFIG;
            case TransmissionType.HEAT -> SpecialColors.TAB_HEAT_CONFIG;
        });
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        this.setTooltip(this.typeTooltips.computeIfAbsent(this.transmission, trans -> TooltipUtils.create((Component)TextComponentUtil.build(trans))));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        this.config.setCurrentType(this.transmission);
        this.config.updateTabs();
    }
}

