/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.EnumMap;
import java.util.Map;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInsetElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.IFluidContainerManager;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiContainerEditModeTab<TILE extends TileEntityMekanism>
extends GuiInsetElement<TILE> {
    private static final ResourceLocation BOTH = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "container_edit_mode_both.png");
    private static final ResourceLocation FILL = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "container_edit_mode_fill.png");
    private static final ResourceLocation EMPTY = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "container_edit_mode_empty.png");
    private final Map<IFluidContainerManager.ContainerEditMode, Tooltip> tooltips = new EnumMap<IFluidContainerManager.ContainerEditMode, Tooltip>(IFluidContainerManager.ContainerEditMode.class);

    public GuiContainerEditModeTab(IGuiWrapper gui, TILE tile) {
        super(BOTH, gui, tile, gui.getXSize(), 138, 26, 18, false);
    }

    @Override
    protected ResourceLocation getOverlay() {
        return switch (((IFluidContainerManager)((Object)((TileEntityMekanism)this.dataSource))).getContainerEditMode()) {
            case IFluidContainerManager.ContainerEditMode.FILL -> FILL;
            case IFluidContainerManager.ContainerEditMode.EMPTY -> EMPTY;
            default -> super.getOverlay();
        };
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        this.setTooltip(this.tooltips.computeIfAbsent(((IFluidContainerManager)((Object)((TileEntityMekanism)this.dataSource))).getContainerEditMode(), mode -> TooltipUtils.create(mode.getTextComponent())));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        PacketUtils.sendToServer(new PacketGuiInteract(button == 0 ? PacketGuiInteract.GuiInteraction.NEXT_MODE : PacketGuiInteract.GuiInteraction.PREVIOUS_MODE, (BlockEntity)this.dataSource));
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    @Override
    protected void colorTab(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, SpecialColors.TAB_CONTAINER_EDIT_MODE);
    }
}

