/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.text;

import java.util.function.BiFunction;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.util.MekanismUtils;

public enum ButtonType {
    NORMAL((field, callback) -> new MekanismImageButton(field.gui(), field.getRelativeRight() - field.getHeight(), field.getRelativeY(), field.getHeight(), 12, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "checkmark.png"), (GuiElement.IClickable)callback)),
    DIGITAL((field, callback) -> {
        MekanismImageButton ret = new MekanismImageButton(field.gui(), field.getRelativeRight() - field.getHeight(), field.getRelativeY(), field.getHeight(), 12, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "checkmark_digital.png"), (GuiElement.IClickable)callback);
        ret.setButtonBackground(GuiElement.ButtonBackground.DIGITAL);
        return ret;
    });

    private final BiFunction<GuiTextField, GuiElement.IClickable, MekanismImageButton> buttonCreator;

    private ButtonType(BiFunction<GuiTextField, GuiElement.IClickable, MekanismImageButton> buttonCreator) {
        this.buttonCreator = buttonCreator;
    }

    public MekanismImageButton getButton(GuiTextField field, GuiElement.IClickable callback) {
        return this.buttonCreator.apply(field, callback);
    }
}

