/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.alias;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.text.IHasTranslationKey;
import mekanism.client.recipe_viewer.alias.IAliasMapping;
import mekanism.client.recipe_viewer.alias.MekanismAliases;
import mekanism.client.recipe_viewer.alias.RVAliasHelper;
import mekanism.common.Mekanism;
import mekanism.common.content.blocktype.FactoryType;
import mekanism.common.item.block.ItemBlockEnergyCube;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.registries.MekanismFluids;
import mekanism.common.registries.MekanismItems;
import mekanism.common.resource.IResource;
import mekanism.common.tags.MekanismTags;
import mekanism.common.tier.FactoryTier;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.material.Fluid;

@NothingNullByDefault
public final class MekanismAliasMapping
implements IAliasMapping {
    @Override
    public <ITEM, FLUID, CHEMICAL> void addAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        this.addChemicalAliases(rv);
        this.addUnitAliases(rv);
        this.addFactoryAliases(rv);
        this.addGearAliases(rv);
        this.addMultiblockAliases(rv);
        this.addStorageAliases(rv);
        this.addTransferAliases(rv);
        this.addUpgradeAliases(rv);
        this.addMiscAliases(rv);
    }

    private <ITEM, FLUID, CHEMICAL> void addChemicalAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addAliases((Holder<Fluid>)MekanismFluids.ETHENE, (Holder<Chemical>)MekanismChemicals.ETHENE, MekanismAliases.ETHENE_ETHYLENE);
    }

    private <ITEM, FLUID, CHEMICAL> void addUnitAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addAliases(MekanismBlocks.MODIFICATION_STATION, MekanismAliases.UNIT_INSTALLER, MekanismAliases.UNIT_INSTALLER_MODULE);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_RADIATION_SHIELDING, MekanismAliases.RADIATION_PROTECTION);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_ENERGY, MekanismAliases.ENERGY_STORAGE);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_FORTUNE, MekanismAliasMapping.getTranslationKey((ResourceKey<Enchantment>)Enchantments.FORTUNE));
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_ATTACK_AMPLIFICATION, MekanismAliases.UNIT_DAMAGE, MekanismAliasMapping.getTranslationKey((ResourceKey<Enchantment>)Enchantments.SHARPNESS));
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_EXCAVATION_ESCALATION, MekanismAliases.UNIT_DIG_SPEED, MekanismAliasMapping.getTranslationKey((ResourceKey<Enchantment>)Enchantments.EFFICIENCY));
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_BLASTING, MekanismAliases.TOOL_HAMMER, MekanismAliases.UNIT_AOE, MekanismAliases.UNIT_AOE_LONG);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_FARMING, MekanismAliases.TOOL_AXE, MekanismAliases.TOOL_HOE, MekanismAliases.TOOL_SHOVEL);
        IHasTranslationKey[] iHasTranslationKeyArray = new IHasTranslationKey[1];
        iHasTranslationKeyArray[0] = () -> ((MobEffect)((MobEffect)MobEffects.NIGHT_VISION.value())).getDescriptionId();
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_VISION_ENHANCEMENT, iHasTranslationKeyArray);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_NUTRITIONAL_INJECTION, MekanismAliases.UNIT_FEEDER);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_GRAVITATIONAL_MODULATING, MekanismAliases.CREATIVE_FLIGHT);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_CHARGE_DISTRIBUTION, MekanismAliases.ITEM_CHARGER);
        IHasTranslationKey[] iHasTranslationKeyArray2 = new IHasTranslationKey[3];
        iHasTranslationKeyArray2[0] = MekanismAliases.AUTO_STEP;
        iHasTranslationKeyArray2[1] = MekanismAliases.STEP_ASSIST;
        iHasTranslationKeyArray2[2] = () -> ((MobEffect)((MobEffect)MobEffects.JUMP.value())).getDescriptionId();
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_HYDRAULIC_PROPULSION, iHasTranslationKeyArray2);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_HYDROSTATIC_REPULSOR, MekanismAliases.UNIT_HYDROSTATIC_SPEED, MekanismAliasMapping.getTranslationKey((ResourceKey<Enchantment>)Enchantments.DEPTH_STRIDER));
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_MOTORIZED_SERVO, MekanismAliasMapping.getTranslationKey((ResourceKey<Enchantment>)Enchantments.SWIFT_SNEAK));
        IHasTranslationKey[] iHasTranslationKeyArray3 = new IHasTranslationKey[1];
        iHasTranslationKeyArray3[0] = () -> ((MobEffect)((MobEffect)MobEffects.MOVEMENT_SPEED.value())).getDescriptionId();
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_LOCOMOTIVE_BOOSTING, iHasTranslationKeyArray3);
        rv.addItemAliases((Holder<Item>)MekanismItems.MODULE_SOUL_SURFER, MekanismAliasMapping.getTranslationKey((ResourceKey<Enchantment>)Enchantments.SOUL_SPEED));
        rv.addModuleAliases(MekanismItems.ITEMS);
    }

    private static IHasTranslationKey getTranslationKey(ResourceKey<Enchantment> enchantmentKey) {
        return () -> Util.makeDescriptionId((String)"enchantment", (ResourceLocation)enchantmentKey.location());
    }

    private <ITEM, FLUID, CHEMICAL> void addFactoryAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        for (FactoryType factoryType : EnumUtils.FACTORY_TYPES) {
            rv.addAliases(List.of(MekanismBlocks.getFactory(FactoryTier.BASIC, factoryType), MekanismBlocks.getFactory(FactoryTier.ADVANCED, factoryType), MekanismBlocks.getFactory(FactoryTier.ELITE, factoryType), MekanismBlocks.getFactory(FactoryTier.ULTIMATE, factoryType)), factoryType.getBaseBlock());
            rv.addAliases(factoryType.getBaseBlock(), () -> Util.makeDescriptionId((String)"alias", (ResourceLocation)Mekanism.rl(factoryType.getRegistryNameComponent())));
        }
    }

    private <ITEM, FLUID, CHEMICAL> void addGearAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addItemHolderAliases(List.of(MekanismItems.ATOMIC_DISASSEMBLER, MekanismItems.MEKA_TOOL), MekanismAliases.TOOL_MULTI, MekanismAliases.TOOL_AXE, MekanismAliases.TOOL_PICKAXE, MekanismAliases.TOOL_SHOVEL, MekanismAliases.TOOL_SWORD, MekanismAliases.TOOL_WEAPON);
        rv.addItemAliases((Holder<Item>)MekanismItems.CONFIGURATOR, MekanismAliases.TOOL_DIAGNOSTIC, MekanismAliases.TOOL_WRENCH);
        rv.addItemHolderAliases(List.of(MekanismItems.NETWORK_READER, MekanismItems.CONFIGURATION_CARD), MekanismAliases.TOOL_DIAGNOSTIC);
        rv.addItemHolderAliases(List.of(MekanismItems.JETPACK, MekanismItems.ARMORED_JETPACK, MekanismItems.MODULE_JETPACK), MekanismAliases.FLIGHT);
        rv.addItemHolderAliases(List.of(MekanismItems.HAZMAT_MASK, MekanismItems.HAZMAT_GOWN, MekanismItems.HAZMAT_PANTS, MekanismItems.HAZMAT_BOOTS), MekanismAliases.RADIATION_PROTECTION);
        rv.addItemHolderAliases(List.of(MekanismItems.FREE_RUNNERS, MekanismItems.ARMORED_FREE_RUNNERS), MekanismAliases.FREE_RUNNER_LONG_FALL, MekanismAliases.FREE_RUNNER_FALL_PROTECTION, MekanismAliases.AUTO_STEP, MekanismAliases.STEP_ASSIST);
        rv.addItemAliases((Holder<Item>)MekanismItems.MEKASUIT_BOOTS, MekanismAliases.FREE_RUNNER_LONG_FALL, MekanismAliases.FREE_RUNNER_FALL_PROTECTION, MekanismAliases.MEKA_SUIT_POWER_ARMOR);
        rv.addItemHolderAliases(List.of(MekanismItems.MEKASUIT_HELMET, MekanismItems.MEKASUIT_BODYARMOR, MekanismItems.MEKASUIT_PANTS), MekanismAliases.MEKA_SUIT_POWER_ARMOR);
        rv.addAliases(FluidUtils.getFilledVariant(MekanismItems.CANTEEN, MekanismFluids.NUTRITIONAL_PASTE), MekanismAliases.CANTEEN_EDIBLE, MekanismAliases.CANTEEN_FOOD_STORAGE);
    }

    private <ITEM, FLUID, CHEMICAL> void addMultiblockAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addAliases(List.of(MekanismBlocks.BOILER_CASING, MekanismBlocks.BOILER_VALVE, MekanismBlocks.PRESSURE_DISPERSER, MekanismBlocks.SUPERHEATING_ELEMENT, MekanismBlocks.STRUCTURAL_GLASS), MekanismAliases.BOILER_COMPONENT);
        rv.addAliases(List.of(MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, MekanismBlocks.THERMAL_EVAPORATION_BLOCK, MekanismBlocks.THERMAL_EVAPORATION_VALVE, MekanismBlocks.STRUCTURAL_GLASS), MekanismAliases.EVAPORATION_COMPONENT);
        rv.addAliases(List.of(MekanismBlocks.INDUCTION_CASING, MekanismBlocks.INDUCTION_PORT, MekanismBlocks.BASIC_INDUCTION_CELL, MekanismBlocks.BASIC_INDUCTION_PROVIDER, MekanismBlocks.ADVANCED_INDUCTION_CELL, MekanismBlocks.ADVANCED_INDUCTION_PROVIDER, MekanismBlocks.ELITE_INDUCTION_CELL, MekanismBlocks.ELITE_INDUCTION_PROVIDER, MekanismBlocks.ULTIMATE_INDUCTION_CELL, MekanismBlocks.ULTIMATE_INDUCTION_PROVIDER, MekanismBlocks.STRUCTURAL_GLASS), MekanismAliases.MATRIX_COMPONENT);
        rv.addAliases(List.of(MekanismBlocks.INDUCTION_CASING, MekanismBlocks.INDUCTION_PORT, MekanismBlocks.BASIC_INDUCTION_CELL, MekanismBlocks.ADVANCED_INDUCTION_CELL, MekanismBlocks.ELITE_INDUCTION_CELL, MekanismBlocks.ULTIMATE_INDUCTION_CELL), MekanismAliases.ENERGY_STORAGE, MekanismAliases.ENERGY_STORAGE_BATTERY, MekanismAliases.ITEM_CHARGER);
        rv.addAliases(List.of(MekanismBlocks.INDUCTION_PORT, MekanismBlocks.BASIC_INDUCTION_PROVIDER, MekanismBlocks.ADVANCED_INDUCTION_PROVIDER, MekanismBlocks.ELITE_INDUCTION_PROVIDER, MekanismBlocks.ULTIMATE_INDUCTION_PROVIDER), MekanismAliases.ENERGY_TRANSFER, MekanismAliases.ENERGY_THROUGHPUT, MekanismAliases.ITEM_CHARGER);
        rv.addAliases(List.of(MekanismBlocks.SPS_CASING, MekanismBlocks.SPS_PORT, MekanismBlocks.SUPERCHARGED_COIL, MekanismBlocks.STRUCTURAL_GLASS), MekanismAliases.SPS_COMPONENT, MekanismAliases.SPS_FULL_COMPONENT);
        rv.addAliases(List.of(MekanismBlocks.DYNAMIC_TANK, MekanismBlocks.DYNAMIC_VALVE, MekanismBlocks.STRUCTURAL_GLASS), MekanismAliases.TANK_COMPONENT, MekanismAliases.FLUID_STORAGE, MekanismAliases.CHEMICAL_STORAGE, MekanismAliases.GAS_STORAGE, MekanismAliases.INFUSE_TYPE_STORAGE, MekanismAliases.INFUSION_STORAGE, MekanismAliases.PIGMENT_STORAGE, MekanismAliases.SLURRY_STORAGE);
    }

    private <ITEM, FLUID, CHEMICAL> void addStorageAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        this.addStorageBlockAliases(rv);
        this.addQIOAliases(rv);
        rv.addAliases(List.of(MekanismBlocks.BASIC_BIN, MekanismBlocks.ADVANCED_BIN, MekanismBlocks.ELITE_BIN, MekanismBlocks.ULTIMATE_BIN, MekanismBlocks.CREATIVE_BIN), MekanismAliases.BIN_DRAWER, MekanismAliases.ITEM_STORAGE);
        rv.addItemAliases(MekanismTags.Items.PERSONAL_STORAGE, MekanismAliases.PERSONAL_BACKPACK, MekanismAliases.ITEM_STORAGE, MekanismAliases.STORAGE_PORTABLE);
        IHasTranslationKey[] iHasTranslationKeyArray = new IHasTranslationKey[3];
        iHasTranslationKeyArray[0] = MekanismAliases.FLUID_STORAGE;
        iHasTranslationKeyArray[1] = MekanismAliases.STORAGE_PORTABLE;
        iHasTranslationKeyArray[2] = () -> ((Item)Items.BUCKET).getDescriptionId();
        rv.addAliases(List.of(MekanismBlocks.BASIC_FLUID_TANK, MekanismBlocks.ADVANCED_FLUID_TANK, MekanismBlocks.ELITE_FLUID_TANK, MekanismBlocks.ULTIMATE_FLUID_TANK, MekanismBlocks.CREATIVE_FLUID_TANK), iHasTranslationKeyArray);
        rv.addAliases(List.of(MekanismBlocks.BASIC_CHEMICAL_TANK, MekanismBlocks.ADVANCED_CHEMICAL_TANK, MekanismBlocks.ELITE_CHEMICAL_TANK, MekanismBlocks.ULTIMATE_CHEMICAL_TANK, MekanismBlocks.CREATIVE_CHEMICAL_TANK), MekanismAliases.CHEMICAL_STORAGE, MekanismAliases.GAS_STORAGE, MekanismAliases.INFUSE_TYPE_STORAGE, MekanismAliases.INFUSION_STORAGE, MekanismAliases.PIGMENT_STORAGE, MekanismAliases.SLURRY_STORAGE);
        rv.addItemAliases((Collection<ItemStack>)List.of(new ItemStack(MekanismBlocks.BASIC_ENERGY_CUBE), new ItemStack(MekanismBlocks.ADVANCED_ENERGY_CUBE), new ItemStack(MekanismBlocks.ELITE_ENERGY_CUBE), new ItemStack(MekanismBlocks.ULTIMATE_ENERGY_CUBE), StorageUtils.getFilledEnergyVariant(ItemBlockEnergyCube.withCreativeSideConfig(ItemBlockEnergyCube.ALL_OUTPUT))), MekanismAliases.ENERGY_STORAGE, MekanismAliases.ENERGY_STORAGE_BATTERY, MekanismAliases.ITEM_CHARGER);
        rv.addItemAliases((Holder<Item>)MekanismItems.ENERGY_TABLET, MekanismAliases.ENERGY_STORAGE, MekanismAliases.ENERGY_STORAGE_BATTERY);
        rv.addItemAliases((Collection<ItemStack>)List.of(new ItemStack(MekanismBlocks.CREATIVE_BIN), new ItemStack(MekanismBlocks.CREATIVE_FLUID_TANK), new ItemStack(MekanismBlocks.CREATIVE_CHEMICAL_TANK), ItemBlockEnergyCube.withCreativeSideConfig(ItemBlockEnergyCube.ALL_INPUT)), MekanismAliases.STORAGE_TRASHCAN, MekanismAliases.STORAGE_VOID);
    }

    private <ITEM, FLUID, CHEMICAL> void addStorageBlockAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addAliases(MekanismBlocks.BRONZE_BLOCK, MekanismAliases.BLOCK_BRONZE);
        rv.addAliases(MekanismBlocks.CHARCOAL_BLOCK, MekanismAliases.BLOCK_CHARCOAL);
        rv.addAliases(MekanismBlocks.STEEL_BLOCK, MekanismAliases.BLOCK_STEEL);
        rv.addAliases(MekanismBlocks.FLUORITE_BLOCK, MekanismAliases.BLOCK_FLUORITE);
        for (Map.Entry<IResource, BlockRegistryObject<?, ?>> entry : MekanismBlocks.PROCESSED_RESOURCE_BLOCKS.entrySet()) {
            rv.addItemAliases((Holder<Item>)entry.getValue().getItemHolder(), () -> Util.makeDescriptionId((String)"alias", (ResourceLocation)Mekanism.rl(((IResource)entry.getKey()).getRegistrySuffix())));
        }
    }

    private <ITEM, FLUID, CHEMICAL> void addQIOAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addAliases(MekanismBlocks.QIO_REDSTONE_ADAPTER, MekanismAliases.QIO_FULL, MekanismAliases.QIO_ADAPTER_EMITTER);
        rv.addAliases(MekanismBlocks.QIO_DRIVE_ARRAY, MekanismAliases.QIO_FULL, MekanismAliases.QIO_DRIVE_BAY);
        rv.addItemAliases((Holder<Item>)MekanismItems.PORTABLE_QIO_DASHBOARD, MekanismAliases.PORTABLE_CRAFTING_TABLE, MekanismAliases.QIO_DASHBOARD_WIRELESS_TERMINAL);
        rv.addAliases(List.of(MekanismBlocks.QIO_DASHBOARD, MekanismItems.PORTABLE_QIO_DASHBOARD), MekanismAliases.QIO_FULL, MekanismAliases.QIO_DASHBOARD_TERMINAL, MekanismAliases.QIO_DASHBOARD_GRID);
        rv.addItemHolderAliases(List.of(MekanismItems.BASE_QIO_DRIVE, MekanismItems.HYPER_DENSE_QIO_DRIVE, MekanismItems.TIME_DILATING_QIO_DRIVE, MekanismItems.SUPERMASSIVE_QIO_DRIVE), MekanismAliases.QIO_FULL, MekanismAliases.QIO_DRIVE_CELL, MekanismAliases.QIO_DRIVE_DISK, MekanismAliases.ITEM_STORAGE);
        rv.addAliases(MekanismBlocks.QIO_EXPORTER, MekanismAliases.QIO_FULL, MekanismAliases.ROUND_ROBIN);
        rv.addAliases(MekanismBlocks.QIO_IMPORTER, MekanismAliases.QIO_FULL);
    }

    private <ITEM, FLUID, CHEMICAL> void addTransferAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addAliases(List.of(MekanismBlocks.BASIC_UNIVERSAL_CABLE, MekanismBlocks.ADVANCED_UNIVERSAL_CABLE, MekanismBlocks.ELITE_UNIVERSAL_CABLE, MekanismBlocks.ULTIMATE_UNIVERSAL_CABLE), MekanismAliases.ENERGY_TRANSFER, MekanismAliases.TRANSMITTER, MekanismAliases.TRANSMITTER_CONDUIT, MekanismAliases.TRANSMITTER_PIPE, MekanismAliases.TRANSMITTER_TUBE);
        rv.addAliases(List.of(MekanismBlocks.BASIC_THERMODYNAMIC_CONDUCTOR, MekanismBlocks.ADVANCED_THERMODYNAMIC_CONDUCTOR, MekanismBlocks.ELITE_THERMODYNAMIC_CONDUCTOR, MekanismBlocks.ULTIMATE_THERMODYNAMIC_CONDUCTOR), MekanismAliases.HEAT_TRANSFER, MekanismAliases.TRANSMITTER, MekanismAliases.TRANSMITTER_CONDUIT, MekanismAliases.TRANSMITTER_PIPE, MekanismAliases.TRANSMITTER_TUBE);
        rv.addAliases(List.of(MekanismBlocks.BASIC_MECHANICAL_PIPE, MekanismBlocks.ADVANCED_MECHANICAL_PIPE, MekanismBlocks.ELITE_MECHANICAL_PIPE, MekanismBlocks.ULTIMATE_MECHANICAL_PIPE), MekanismAliases.FLUID_TRANSFER, MekanismAliases.TRANSMITTER, MekanismAliases.TRANSMITTER_CONDUIT, MekanismAliases.TRANSMITTER_TUBE);
        rv.addAliases(List.of(MekanismBlocks.BASIC_LOGISTICAL_TRANSPORTER, MekanismBlocks.ADVANCED_LOGISTICAL_TRANSPORTER, MekanismBlocks.ELITE_LOGISTICAL_TRANSPORTER, MekanismBlocks.ULTIMATE_LOGISTICAL_TRANSPORTER, MekanismBlocks.RESTRICTIVE_TRANSPORTER, MekanismBlocks.DIVERSION_TRANSPORTER), MekanismAliases.ITEM_TRANSFER, MekanismAliases.TRANSMITTER, MekanismAliases.TRANSMITTER_CONDUIT, MekanismAliases.TRANSMITTER_PIPE, MekanismAliases.TRANSMITTER_TUBE);
        rv.addAliases(MekanismBlocks.DIVERSION_TRANSPORTER, MekanismAliases.REDSTONE_CONTROL);
        rv.addAliases(MekanismBlocks.LOGISTICAL_SORTER, MekanismAliases.ITEM_TRANSFER, MekanismAliases.ROUND_ROBIN);
        rv.addAliases(List.of(MekanismBlocks.BASIC_PRESSURIZED_TUBE, MekanismBlocks.ADVANCED_PRESSURIZED_TUBE, MekanismBlocks.ELITE_PRESSURIZED_TUBE, MekanismBlocks.ULTIMATE_PRESSURIZED_TUBE), MekanismAliases.CHEMICAL_TRANSFER, MekanismAliases.GAS_TRANSFER, MekanismAliases.INFUSE_TYPE_TRANSFER, MekanismAliases.INFUSION_TRANSFER, MekanismAliases.PIGMENT_TRANSFER, MekanismAliases.SLURRY_TRANSFER, MekanismAliases.TRANSMITTER, MekanismAliases.TRANSMITTER_CONDUIT, MekanismAliases.TRANSMITTER_PIPE);
        rv.addAliases(MekanismBlocks.QUANTUM_ENTANGLOPORTER, MekanismAliases.ENERGY_TRANSFER, MekanismAliases.HEAT_TRANSFER, MekanismAliases.FLUID_TRANSFER, MekanismAliases.ITEM_TRANSFER, MekanismAliases.CHEMICAL_TRANSFER, MekanismAliases.GAS_TRANSFER, MekanismAliases.INFUSE_TYPE_TRANSFER, MekanismAliases.INFUSION_TRANSFER, MekanismAliases.PIGMENT_TRANSFER, MekanismAliases.SLURRY_TRANSFER, MekanismAliases.QE_TESSERACT, MekanismAliases.QE_ENDER_TANK, MekanismAliases.TRANSMITTER, MekanismAliases.TRANSMITTER_CONDUIT, MekanismAliases.TRANSMITTER_PIPE, MekanismAliases.TRANSMITTER_TUBE);
    }

    private <ITEM, FLUID, CHEMICAL> void addUpgradeAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addItemAliases((Holder<Item>)MekanismItems.SPEED_UPGRADE, MekanismAliases.UPGRADE_AUGMENT, MekanismAliases.UPGRADE_OVERCLOCK);
        rv.addItemAliases((Holder<Item>)MekanismItems.ENERGY_UPGRADE, MekanismAliases.UPGRADE_AUGMENT, MekanismAliases.ENERGY_STORAGE);
        rv.addItemAliases((Holder<Item>)MekanismItems.FILTER_UPGRADE, MekanismAliases.UPGRADE_AUGMENT);
        rv.addItemAliases((Holder<Item>)MekanismItems.MUFFLING_UPGRADE, MekanismAliases.UPGRADE_AUGMENT, MekanismAliases.UPGRADE_MUFFLER);
        rv.addItemAliases((Holder<Item>)MekanismItems.CHEMICAL_UPGRADE, MekanismAliases.UPGRADE_AUGMENT);
        rv.addItemAliases((Holder<Item>)MekanismItems.ANCHOR_UPGRADE, MekanismAliases.UPGRADE_AUGMENT, MekanismAliases.CHUNK_LOADER);
        rv.addItemAliases((Holder<Item>)MekanismItems.STONE_GENERATOR_UPGRADE, MekanismAliases.UPGRADE_AUGMENT, MekanismAliases.UPGRADE_HOLE_FILLER);
        rv.addItemHolderAliases(List.of(MekanismItems.BASIC_TIER_INSTALLER, MekanismItems.ADVANCED_TIER_INSTALLER, MekanismItems.ELITE_TIER_INSTALLER, MekanismItems.ULTIMATE_TIER_INSTALLER), MekanismAliases.INSTALLER_FACTORY, MekanismAliases.INSTALLER_UPGRADE);
    }

    private <ITEM, FLUID, CHEMICAL> void addMiscAliases(RVAliasHelper<ITEM, FLUID, CHEMICAL> rv) {
        rv.addItemAliases((Holder<Item>)MekanismItems.CRAFTING_FORMULA, MekanismAliases.CRAFTING_PATTERN);
        rv.addAliases(MekanismBlocks.FORMULAIC_ASSEMBLICATOR, MekanismAliases.AUTO_CRAFTER);
        rv.addAliases(MekanismBlocks.DIMENSIONAL_STABILIZER, MekanismAliases.CHUNK_LOADER);
        rv.addAliases(MekanismBlocks.FLUIDIC_PLENISHER, MekanismAliases.PLENISHER_PLACER, MekanismAliases.PLENISHER_REVERSE);
        rv.addAliases(MekanismBlocks.OREDICTIONIFICATOR, MekanismAliases.TAG_CONVERTER);
        rv.addAliases(MekanismBlocks.ROTARY_CONDENSENTRATOR, MekanismAliases.ROTARY_DECONDENSENTRATOR, MekanismAliases.ROTARY_CHEMICAL_TO_FLUID, MekanismAliases.ROTARY_GAS_TO_FLUID, MekanismAliases.ROTARY_FLUID_TO_CHEMICAL, MekanismAliases.ROTARY_FLUID_TO_GAS);
    }
}

