/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.alias;

import java.util.Collection;
import java.util.List;
import mekanism.api.chemical.Chemical;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.text.IHasTranslationKey;
import mekanism.common.Mekanism;
import mekanism.common.content.gear.IModuleItem;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.registration.impl.ItemDeferredRegister;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public interface RVAliasHelper<ITEM, FLUID, CHEMICAL> {
    public ITEM ingredient(ItemStack var1);

    public ITEM itemIngredient(Holder<Item> var1);

    public List<ITEM> itemTagContents(TagKey<Item> var1);

    public FLUID fluidIngredient(Holder<Fluid> var1);

    public FLUID ingredient(FluidStack var1);

    public List<FLUID> fluidTagContents(TagKey<Fluid> var1);

    public CHEMICAL chemicalIngredient(Holder<Chemical> var1);

    public List<CHEMICAL> chemicalTagContents(TagKey<Chemical> var1);

    default public void addAliases(Holder<Fluid> fluidProvider, Holder<Chemical> chemicalProvider, IHasTranslationKey ... aliases) {
        this.addFluidAliases(fluidProvider, aliases);
        this.addChemicalAliases(chemicalProvider, aliases);
    }

    default public void addAliases(BlockRegistryObject<?, ?> block, IHasTranslationKey ... aliases) {
        this.addItemAliases((Holder<Item>)block.getItemHolder(), aliases);
    }

    default public void addAliases(ItemStack stack, IHasTranslationKey ... aliases) {
        this.addItemAliases(List.of(this.ingredient(stack)), aliases);
    }

    default public void addAliases(Collection<? extends ItemLike> stacks, IHasTranslationKey ... aliases) {
        this.addItemAliases((Collection<ItemStack>)stacks.stream().map(ItemStack::new).toList(), aliases);
    }

    default public void addItemHolderAliases(Collection<? extends Holder<Item>> items, IHasTranslationKey ... aliases) {
        this.addItemAliases((Collection<ItemStack>)items.stream().map(ItemStack::new).toList(), aliases);
    }

    default public void addItemAliases(Holder<Item> item, IHasTranslationKey ... aliases) {
        this.addItemAliases(List.of(this.itemIngredient(item)), aliases);
    }

    default public void addItemAliases(Collection<ItemStack> stacks, IHasTranslationKey ... aliases) {
        this.addItemAliases(stacks.stream().map(this::ingredient).toList(), aliases);
    }

    default public void addItemAliases(TagKey<Item> tag, IHasTranslationKey ... aliases) {
        if (aliases.length == 0) {
            Mekanism.logger.warn("Expected to have at least one alias for item tag: {}", (Object)tag.location());
        } else {
            this.addItemAliases(this.itemTagContents(tag), aliases);
        }
    }

    default public void addFluidAliases(Holder<Fluid> fluid, IHasTranslationKey ... aliases) {
        this.addFluidAlias(this.fluidIngredient(fluid), aliases);
    }

    default public void addAliases(FluidStack stack, IHasTranslationKey ... aliases) {
        this.addFluidAliases(List.of(this.ingredient(stack)), aliases);
    }

    default public void addFluidAliases(TagKey<Fluid> tag, IHasTranslationKey ... aliases) {
        if (aliases.length == 0) {
            Mekanism.logger.warn("Expected to have at least one alias for fluid tag: {}", (Object)tag.location());
        } else {
            this.addFluidAliases(this.fluidTagContents(tag), aliases);
        }
    }

    default public void addChemicalAliases(Holder<Chemical> chemical, IHasTranslationKey ... aliases) {
        this.addChemicalAliases(List.of(this.chemicalIngredient(chemical)), aliases);
    }

    default public void addChemicalAliases(TagKey<Chemical> tag, IHasTranslationKey ... aliases) {
        if (aliases.length == 0) {
            Mekanism.logger.warn("Expected to have at least one alias for chemical tag: {}", (Object)tag.location());
        } else {
            this.addChemicalAliases(this.chemicalTagContents(tag), aliases);
        }
    }

    default public void addItemAlias(ITEM item, IHasTranslationKey ... aliases) {
        this.addItemAliases(List.of(item), aliases);
    }

    public void addItemAliases(List<ITEM> var1, IHasTranslationKey ... var2);

    default public void addFluidAlias(FLUID fluid, IHasTranslationKey ... aliases) {
        this.addFluidAliases(List.of(fluid), aliases);
    }

    public void addFluidAliases(List<FLUID> var1, IHasTranslationKey ... var2);

    default public void addChemicalAlias(CHEMICAL chemical, IHasTranslationKey ... aliases) {
        this.addChemicalAliases(List.of(chemical), aliases);
    }

    public void addChemicalAliases(List<CHEMICAL> var1, IHasTranslationKey ... var2);

    default public void addModuleAliases(ItemDeferredRegister items) {
        for (Holder entry : items.getEntries()) {
            Object object = entry.value();
            if (!(object instanceof IModuleItem)) continue;
            IModuleItem module = (IModuleItem)object;
            this.addItemAliases((Holder<Item>)entry, (IHasTranslationKey[])IModuleHelper.INSTANCE.getSupportedItems(module.getModuleData()).stream().map(item -> () -> ((Item)item).getDescriptionId()).toArray(IHasTranslationKey[]::new));
        }
    }
}

