/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.data.RenderData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidRenderData
extends RenderData {
    public final FluidStack fluidType;

    public FluidRenderData(BlockPos renderLocation, int width, int height, int length, FluidStack fluidType) {
        super(renderLocation, width, height, length);
        this.fluidType = fluidType;
    }

    @Override
    public boolean isGaseous() {
        return MekanismUtils.lighterThanAirGas(this.fluidType);
    }

    public int getColorARGB() {
        return MekanismRenderer.getColorARGB(this.fluidType);
    }

    @Override
    public int getColorARGB(float scale) {
        return MekanismRenderer.getColorARGB(this.fluidType, scale);
    }

    @Override
    public int calculateGlowLight(int light) {
        return MekanismRenderer.calculateGlowLight(light, this.fluidType);
    }

    @Override
    public TextureAtlasSprite getTexture() {
        return MekanismRenderer.getFluidTexture(this.fluidType, MekanismRenderer.FluidTextureType.STILL);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + FluidStack.hashFluidAndComponents((FluidStack)this.fluidType);
    }

    @Override
    public boolean equals(@Nullable Object data) {
        if (data == this) {
            return true;
        }
        if (data == null) {
            return false;
        }
        return data.getClass() == FluidRenderData.class && this.equalsCommonFluid(data);
    }

    protected boolean equalsCommonFluid(Object data) {
        return super.equals(data) && FluidStack.isSameFluidSameComponents((FluidStack)this.fluidType, (FluidStack)((FluidRenderData)data).fluidType);
    }

    public static class Scaled
    extends FluidRenderData
    implements RenderData.ScaledRenderData {
        private final float scale;

        public Scaled(BlockPos renderLocation, int width, int height, int length, FluidStack fluidType, float scale) {
            super(renderLocation, width, height, length, fluidType);
            this.scale = scale;
        }

        @Override
        public float scale() {
            return this.scale;
        }

        @Override
        public boolean equals(@Nullable Object data) {
            if (data == this) {
                return true;
            }
            if (data == null) {
                return false;
            }
            return data.getClass() == Scaled.class && this.equalsCommonFluid(data) && this.scale == ((Scaled)data).scale;
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + Float.hashCode(this.scale);
        }
    }
}

