/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.client.render.obj.TransmitterModelConfiguration;
import mekanism.client.render.obj.VisibleModelConfiguration;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.obj.ObjModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@NothingNullByDefault
public class TransmitterBakedModel
extends BakedModelWrapper<BakedModel> {
    private static final ChunkRenderTypeSet CUTOUT = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout()});
    private static final ChunkRenderTypeSet FULL = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.cutout(), RenderType.translucent()});
    private final IGeometryBakingContext owner;
    private final ModelBaker baker;
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private final ModelState modelTransform;
    private final ItemOverrides overrides;
    private final LoadingCache<SidedConnection, List<BakedQuad>> internalPartsCache;
    @Nullable
    private final LoadingCache<SidedConnection, List<BakedQuad>> glassPartsCache;
    private final LoadingCache<TransmitterDataKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TransmitterDataKey, List<BakedQuad>>(){

        @NotNull
        public List<BakedQuad> load(@NotNull TransmitterDataKey key) {
            LoadingCache<SidedConnection, List<BakedQuad>> partsCache = key.renderGlass ? Objects.requireNonNull(TransmitterBakedModel.this.glassPartsCache) : TransmitterBakedModel.this.internalPartsCache;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (Direction side : EnumUtils.DIRECTIONS) {
                ConnectionType connectionType = key.data.getConnectionType(side);
                TransmitterModelConfiguration.IconStatus iconStatus = TransmitterModelConfiguration.getIconStatus(key.data, side, connectionType);
                SidedConnection sidedConnection = new SidedConnection(side, connectionType, iconStatus);
                quads.addAll((Collection)partsCache.getUnchecked((Object)sidedConnection));
            }
            return quads;
        }
    });

    public TransmitterBakedModel(ObjModel internal, @Nullable ObjModel glass, IGeometryBakingContext owner, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides) {
        super(internal.bake((IGeometryBakingContext)new VisibleModelConfiguration(owner, Arrays.stream(EnumUtils.DIRECTIONS).map(side -> TransmitterBakedModel.getPartName(side, ConnectionType.NONE)).toList()), baker, spriteGetter, modelTransform, overrides));
        this.owner = owner;
        this.baker = baker;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.overrides = overrides;
        this.internalPartsCache = CacheBuilder.newBuilder().build(this.createPartCacheLoader(internal));
        this.glassPartsCache = glass == null ? null : CacheBuilder.newBuilder().build(this.createPartCacheLoader(glass));
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (side != null) {
            return Collections.emptyList();
        }
        TransmitterModelData data = (TransmitterModelData)extraData.get(TileEntityTransmitter.TRANSMITTER_PROPERTY);
        if (data != null) {
            boolean renderGlass;
            boolean bl = renderGlass = renderType == RenderType.translucent();
            if (renderGlass && (this.glassPartsCache == null || !data.getHasColor())) {
                return Collections.emptyList();
            }
            return (List)this.cache.getUnchecked((Object)new TransmitterDataKey(data, renderGlass));
        }
        return super.getQuads(state, null, rand, extraData, renderType);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return this.glassPartsCache == null ? CUTOUT : FULL;
    }

    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        if (this.glassPartsCache == null) {
            return List.of(Sheets.cutoutBlockSheet());
        }
        return List.of(Sheets.cutoutBlockSheet(), fabulous ? Sheets.translucentCullBlockSheet() : Sheets.translucentItemSheet());
    }

    public List<BakedModel> getRenderPasses(ItemStack stack, boolean fabulous) {
        return Collections.singletonList(this);
    }

    private static String getPartName(Direction side, ConnectionType connectionType) {
        return side.getSerializedName() + connectionType.name();
    }

    private CacheLoader<SidedConnection, List<BakedQuad>> createPartCacheLoader(final ObjModel model) {
        return new CacheLoader<SidedConnection, List<BakedQuad>>(){

            @NotNull
            public List<BakedQuad> load(@NotNull SidedConnection key) {
                Direction side = key.side();
                ConnectionType connectionType = key.connection();
                String part = TransmitterBakedModel.getPartName(side, connectionType);
                if (!model.getRootComponentNames().contains(part)) {
                    return Collections.emptyList();
                }
                TransmitterModelConfiguration.IconStatus iconStatus = key.status();
                ModelState transform = TransmitterBakedModel.this.modelTransform;
                if (connectionType == ConnectionType.NONE && iconStatus.getAngle() > 0.0f) {
                    Vector3f vecForDirection = Vec3.atLowerCornerOf((Vec3i)side.getNormal()).toVector3f();
                    vecForDirection.mul(-1.0f);
                    Quaternionf quaternion = new Quaternionf().setAngleAxis(iconStatus.getAngle(), vecForDirection.x, vecForDirection.y, vecForDirection.z);
                    Transformation matrix = new Transformation(null, quaternion, null, null);
                    transform = new SimpleModelState(transform.getRotation().compose(matrix), transform.isUvLocked());
                }
                BakedModel bakedModel = model.bake((IGeometryBakingContext)new TransmitterModelConfiguration(TransmitterBakedModel.this.owner, part, iconStatus), TransmitterBakedModel.this.baker, TransmitterBakedModel.this.spriteGetter, transform, TransmitterBakedModel.this.overrides);
                return bakedModel.getQuads(null, null, RandomSource.create(), ModelData.EMPTY, null);
            }
        };
    }

    private static class TransmitterDataKey {
        private final TransmitterModelData data;
        private final boolean renderGlass;
        private final int hash;

        public TransmitterDataKey(TransmitterModelData data, boolean renderGlass) {
            this.data = data;
            this.renderGlass = renderGlass;
            this.hash = 31 * this.data.getConnectionsMap().hashCode() + Boolean.hashCode(this.renderGlass);
        }

        public int hashCode() {
            return this.hash;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TransmitterDataKey)) return false;
            TransmitterDataKey other = (TransmitterDataKey)obj;
            if (this.renderGlass != other.renderGlass) return false;
            if (!this.data.getConnectionsMap().equals(other.data.getConnectionsMap())) return false;
            return true;
        }
    }

    private record SidedConnection(Direction side, ConnectionType connection, TransmitterModelConfiguration.IconStatus status) {
    }
}

