/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public abstract class MultiblockTileEntityRenderer<MULTIBLOCK extends MultiblockData, TILE extends TileEntityMultiblock<MULTIBLOCK>>
extends MekanismTileEntityRenderer<TILE> {
    protected MultiblockTileEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected final void render(TILE tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        this.render(tile, tile.getMultiblock(), partialTick, matrix, renderer, light, overlayLight, profiler);
    }

    protected abstract void render(TILE var1, MULTIBLOCK var2, float var3, PoseStack var4, MultiBufferSource var5, int var6, int var7, ProfilerFiller var8);

    public final boolean shouldRenderOffScreen(TILE tile) {
        return true;
    }

    public final boolean shouldRender(TILE tile, Vec3 camera) {
        if (((TileEntityMultiblock)tile).isMaster()) {
            MultiblockData multiblock = tile.getMultiblock();
            return multiblock.isFormed() && this.shouldRender(tile, multiblock, camera) && super.shouldRender(tile, camera);
        }
        return false;
    }

    protected boolean shouldRender(TILE tile, MULTIBLOCK multiblock, Vec3 camera) {
        return ((MultiblockData)multiblock).renderLocation != null;
    }

    public AABB getRenderBoundingBox(TILE tile) {
        if (((TileEntityMultiblock)tile).isMaster()) {
            MultiblockData multiblock = tile.getMultiblock();
            VoxelCuboid bounds = multiblock.getBounds();
            if (multiblock.isFormed() && bounds != null) {
                return bounds.asAABB();
            }
        }
        return super.getRenderBoundingBox(tile);
    }
}

