/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.heat;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.ArrayList;
import java.util.List;
import mekanism.common.attachments.containers.creator.BaseContainerCreator;
import mekanism.common.attachments.containers.creator.IBasicContainerCreator;
import mekanism.common.attachments.containers.heat.AttachedHeat;
import mekanism.common.attachments.containers.heat.ComponentBackedHeatCapacitor;
import mekanism.common.attachments.containers.heat.HeatCapacitorData;

public class HeatCapacitorsBuilder {
    private final List<IBasicContainerCreator<? extends ComponentBackedHeatCapacitor>> capacitorCreators = new ArrayList<IBasicContainerCreator<? extends ComponentBackedHeatCapacitor>>();
    private final DoubleList defaultHeatCapacities = new DoubleArrayList();

    public static HeatCapacitorsBuilder builder() {
        return new HeatCapacitorsBuilder();
    }

    private HeatCapacitorsBuilder() {
    }

    public BaseContainerCreator<AttachedHeat, ComponentBackedHeatCapacitor> build() {
        return new BaseHeatCapacitorCreator(this.capacitorCreators, this.defaultHeatCapacities);
    }

    public HeatCapacitorsBuilder addBasic(double heatCapacity, double inverseConductionCoefficient, double inverseInsulationCoefficient) {
        return this.addCapacitor(heatCapacity, (type, attachedTo, containerIndex) -> new ComponentBackedHeatCapacitor(attachedTo, containerIndex, inverseConductionCoefficient, inverseInsulationCoefficient, heatCapacity));
    }

    public HeatCapacitorsBuilder addCapacitor(IBasicContainerCreator<? extends ComponentBackedHeatCapacitor> capacitor) {
        return this.addCapacitor(1.0, capacitor);
    }

    public HeatCapacitorsBuilder addCapacitor(double defaultHeatCapacity, IBasicContainerCreator<? extends ComponentBackedHeatCapacitor> capacitor) {
        this.defaultHeatCapacities.add(defaultHeatCapacity);
        this.capacitorCreators.add(capacitor);
        return this;
    }

    private static class BaseHeatCapacitorCreator
    extends BaseContainerCreator<AttachedHeat, ComponentBackedHeatCapacitor> {
        private final DoubleList defaultHeatCapacities;

        public BaseHeatCapacitorCreator(List<IBasicContainerCreator<? extends ComponentBackedHeatCapacitor>> creators, DoubleList defaultHeatCapacities) {
            super(creators);
            this.defaultHeatCapacities = defaultHeatCapacities;
        }

        @Override
        public AttachedHeat initStorage(int containers) {
            ArrayList<HeatCapacitorData> capacitors = new ArrayList<HeatCapacitorData>(containers);
            for (int capacitor = 0; capacitor < containers; ++capacitor) {
                capacitors.add(new HeatCapacitorData(this.defaultHeatCapacities.getDouble(capacitor)));
            }
            return new AttachedHeat(capacitors);
        }
    }
}

