/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.attachments.containers.item;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.containers.ComponentBackedContainer;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.item.AttachedItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ComponentBackedInventorySlot
extends ComponentBackedContainer<ItemStack, AttachedItems>
implements IInventorySlot {
    private final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract;
    private final BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert;
    private final Predicate<@NotNull ItemStack> validator;
    private final boolean obeyStackLimit;
    private final int limit;

    public ComponentBackedInventorySlot(ItemStack attachedTo, int slotIndex, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator) {
        this(attachedTo, slotIndex, canExtract, canInsert, validator, true, 99);
    }

    public ComponentBackedInventorySlot(ItemStack attachedTo, int slotIndex, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canExtract, BiPredicate<@NotNull ItemStack, @NotNull AutomationType> canInsert, Predicate<@NotNull ItemStack> validator, boolean obeyStackLimit, int limit) {
        super(attachedTo, slotIndex);
        this.canExtract = canExtract;
        this.canInsert = canInsert;
        this.validator = validator;
        this.obeyStackLimit = obeyStackLimit;
        this.limit = limit;
    }

    @Override
    protected ItemStack copy(ItemStack toCopy) {
        return toCopy.copy();
    }

    @Override
    protected boolean isEmpty(ItemStack value) {
        return value.isEmpty();
    }

    @Override
    protected ContainerType<?, AttachedItems, ?> containerType() {
        return ContainerType.ITEM;
    }

    @Override
    public ItemStack getStack() {
        return (ItemStack)this.getContents((AttachedItems)this.getAttached());
    }

    @Override
    public final void setStack(ItemStack stack) {
        this.setContents((AttachedItems)this.getAttached(), stack);
    }

    private boolean isItemValidForInsertion(ItemStack stack, AutomationType automationType) {
        return this.validator.test(stack) && this.canInsert.test(stack, automationType);
    }

    @Override
    public final ItemStack insertItem(ItemStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        AttachedItems attachedItems = (AttachedItems)this.getAttached();
        return this.insertItem(attachedItems, (ItemStack)this.getContents(attachedItems), stack, action, automationType);
    }

    public ItemStack insertItem(AttachedItems attachedItems, ItemStack current, ItemStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int needed = this.getLimit(stack) - current.getCount();
        if (needed <= 0 || !this.isItemValidForInsertion(stack, automationType)) {
            return stack;
        }
        if (current.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)current, (ItemStack)stack)) {
            int toAdd = Math.min(stack.getCount(), needed);
            if (action.execute()) {
                this.setContents(attachedItems, stack.copyWithCount(current.getCount() + toAdd));
            }
            return stack.copyWithCount(stack.getCount() - toAdd);
        }
        return stack;
    }

    @Override
    public ItemStack extractItem(int amount, Action action, AutomationType automationType) {
        if (amount < 1) {
            return ItemStack.EMPTY;
        }
        AttachedItems attachedItems = (AttachedItems)this.getAttached();
        ItemStack current = (ItemStack)this.getContents(attachedItems);
        if (current.isEmpty() || !this.canExtract.test(current, automationType)) {
            return ItemStack.EMPTY;
        }
        int currentAmount = Math.min(current.getCount(), current.getMaxStackSize());
        if (currentAmount < amount) {
            amount = currentAmount;
        }
        ItemStack toReturn = current.copyWithCount(amount);
        if (action.execute()) {
            this.setContents(attachedItems, current.copyWithCount(current.getCount() - amount));
        }
        return toReturn;
    }

    @Override
    public int getLimit(ItemStack stack) {
        return this.obeyStackLimit && !stack.isEmpty() ? Math.min(this.limit, stack.getMaxStackSize()) : this.limit;
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return this.validator.test(stack);
    }

    @Override
    public final int setStackSize(int amount, Action action) {
        AttachedItems attachedItems = (AttachedItems)this.getAttached();
        return this.setStackSize(attachedItems, (ItemStack)this.getContents(attachedItems), amount, action);
    }

    protected int setStackSize(AttachedItems attachedItems, ItemStack current, int amount, Action action) {
        if (current.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setContents(attachedItems, ItemStack.EMPTY);
            }
            return 0;
        }
        int maxStackSize = this.getLimit(current);
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (current.getCount() == amount || action.simulate()) {
            return amount;
        }
        this.setContents(attachedItems, current.copyWithCount(amount));
        return amount;
    }

    @Override
    public int growStack(int amount, Action action) {
        AttachedItems attachedItems = (AttachedItems)this.getAttached();
        ItemStack stack = (ItemStack)this.getContents(attachedItems);
        int current = stack.getCount();
        if (current == 0) {
            return 0;
        }
        if (amount > 0) {
            amount = Math.min(amount, this.getLimit(stack));
        }
        int newSize = this.setStackSize(attachedItems, stack, current + amount, action);
        return newSize - current;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ItemStack current = this.getStack();
        if (!current.isEmpty()) {
            nbt.put("item", SerializerHelper.saveOversized(provider, current));
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.setStack(SerializerHelper.parseOversizedOptional(provider, nbt.getCompound("item")));
    }
}

