/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.lib.WildcardMatcher;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;

public class MinerTagFilter
extends MinerFilter<MinerTagFilter>
implements ITagFilter<MinerTagFilter> {
    public static final MapCodec<MinerTagFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> MinerTagFilter.baseMinerCodec(instance).and((App)Codec.STRING.fieldOf("tag").forGetter(MinerTagFilter::getTagName)).apply((Applicative)instance, MinerTagFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MinerTagFilter> STREAM_CODEC = StreamCodec.composite(MinerTagFilter.baseMinerStreamCodec(MinerTagFilter::new), Function.identity(), (StreamCodec)ByteBufCodecs.STRING_UTF8, MinerTagFilter::getTagName, (filter, tagName) -> {
        filter.tagName = tagName;
        return filter;
    });
    private String tagName;

    public MinerTagFilter() {
    }

    protected MinerTagFilter(boolean enabled, Item replaceTarget, boolean requiresReplacement, String tagName) {
        super(enabled, replaceTarget, requiresReplacement);
        this.tagName = tagName;
    }

    public MinerTagFilter(MinerTagFilter filter) {
        super(filter);
        this.tagName = filter.tagName;
    }

    @Override
    public boolean canFilter(BlockState state) {
        return state.getTags().anyMatch(tag -> WildcardMatcher.matches(this.tagName, tag));
    }

    @Override
    public boolean hasBlacklistedElement() {
        return TagCache.tagHasMinerBlacklisted(this.tagName);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.tagName.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        MinerTagFilter other = (MinerTagFilter)o;
        return this.tagName.equals(other.tagName);
    }

    @Override
    public MinerTagFilter clone() {
        return new MinerTagFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_TAG_FILTER;
    }

    @Override
    public void setTagName(String name) {
        this.tagName = name;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }
}

