/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import java.util.Collection;
import mekanism.api.math.MathUtils;
import mekanism.common.content.network.transmitter.MechanicalPipe;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidTransmitterSaveTarget
extends Target<SaveHandler, FluidStack> {
    public FluidTransmitterSaveTarget(Collection<MechanicalPipe> transmitters) {
        super(transmitters.size());
        for (MechanicalPipe transmitter : transmitters) {
            this.addHandler(new SaveHandler(transmitter));
        }
    }

    @Override
    protected void acceptAmount(SaveHandler handler, SplitInfo splitInfo, @NotNull FluidStack resource, long amount) {
        handler.acceptAmount(splitInfo, resource, MathUtils.clampToInt(amount));
    }

    @Override
    protected long simulate(SaveHandler handler, @NotNull FluidStack resource, long amount) {
        return handler.simulate(resource.copyWithAmount(MathUtils.clampToInt(amount))).intValue();
    }

    public void saveShare() {
        for (SaveHandler handler : this.handlers) {
            handler.saveShare();
        }
    }

    public static class SaveHandler {
        private FluidStack currentStored = FluidStack.EMPTY;
        private final MechanicalPipe transmitter;

        public SaveHandler(MechanicalPipe transmitter) {
            this.transmitter = transmitter;
        }

        protected void acceptAmount(SplitInfo splitInfo, @NotNull FluidStack resource, int amount) {
            amount = Math.min(amount, MathUtils.clampToInt(this.transmitter.getCapacity() - (long)this.currentStored.getAmount()));
            if (this.currentStored.isEmpty()) {
                this.currentStored = resource.copyWithAmount(amount);
            } else {
                this.currentStored.grow(amount);
            }
            splitInfo.send(amount);
        }

        protected Integer simulate(@NotNull FluidStack fluidStack) {
            if (!this.currentStored.isEmpty() && !FluidStack.isSameFluidSameComponents((FluidStack)this.currentStored, (FluidStack)fluidStack)) {
                return 0;
            }
            return Math.min(fluidStack.getAmount(), MathUtils.clampToInt(this.transmitter.getCapacity() - (long)this.currentStored.getAmount()));
        }

        protected void saveShare() {
            if (this.currentStored.isEmpty() != this.transmitter.saveShare.isEmpty() || !this.currentStored.isEmpty() && !FluidStack.matches((FluidStack)this.currentStored, (FluidStack)this.transmitter.saveShare)) {
                this.transmitter.saveShare = this.currentStored;
                this.transmitter.getTransmitterTile().markForSave();
            }
        }
    }
}

