/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.teleporter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import mekanism.api.security.SecurityMode;
import mekanism.api.text.EnumColor;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IColorableFrequency;
import mekanism.common.tile.interfaces.ITileWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class TeleporterFrequency
extends Frequency
implements IColorableFrequency {
    public static final Codec<TeleporterFrequency> CODEC = RecordCodecBuilder.create(instance -> TeleporterFrequency.baseCodec(instance).and((App)EnumColor.CODEC.fieldOf("color").forGetter(TeleporterFrequency::getColor)).apply((Applicative)instance, (name, owner, securityMode, color) -> {
        TeleporterFrequency frequency = new TeleporterFrequency((String)name, owner.orElse(null), (SecurityMode)securityMode);
        frequency.color = color;
        return frequency;
    }));
    public static final StreamCodec<ByteBuf, TeleporterFrequency> STREAM_CODEC = StreamCodec.composite(TeleporterFrequency.baseStreamCodec(TeleporterFrequency::new), Function.identity(), EnumColor.STREAM_CODEC, TeleporterFrequency::getColor, (frequency, color) -> {
        frequency.color = color;
        return frequency;
    });
    private final Set<GlobalPos> activeCoords = new ObjectOpenHashSet();
    private EnumColor color = EnumColor.PURPLE;

    public TeleporterFrequency(String n, @Nullable UUID uuid, SecurityMode securityMode) {
        super(FrequencyType.TELEPORTER, n, uuid, securityMode);
    }

    private TeleporterFrequency(String name, @Nullable UUID owner, String ownerName, SecurityMode securityMode) {
        super(FrequencyType.TELEPORTER, name, owner, ownerName, securityMode);
    }

    public Set<GlobalPos> getActiveCoords() {
        return this.activeCoords;
    }

    @Override
    public int getSyncHash() {
        int code = super.getSyncHash();
        code = 31 * code + this.color.ordinal();
        return code;
    }

    @Override
    public EnumColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(EnumColor color) {
        if (this.color != color) {
            this.color = color;
            this.dirty = true;
        }
    }

    @Override
    public boolean update(BlockEntity tile) {
        boolean changedData = super.update(tile);
        this.activeCoords.add(this.getCoord(tile));
        return changedData;
    }

    @Override
    public boolean onDeactivate(BlockEntity tile) {
        boolean changedData = super.onDeactivate(tile);
        this.activeCoords.remove(this.getCoord(tile));
        return changedData;
    }

    private GlobalPos getCoord(BlockEntity tile) {
        if (tile instanceof ITileWrapper) {
            ITileWrapper tileWrapper = (ITileWrapper)tile;
            return tileWrapper.getTileGlobalPos();
        }
        return GlobalPos.of((ResourceKey)tile.getLevel().dimension(), (BlockPos)tile.getBlockPos());
    }

    public GlobalPos getClosestCoords(GlobalPos pos) {
        GlobalPos closest = null;
        for (GlobalPos iterCoord : this.activeCoords) {
            if (iterCoord.equals((Object)pos)) continue;
            if (closest == null) {
                closest = iterCoord;
                continue;
            }
            if (pos.dimension() != closest.dimension() && pos.dimension() == iterCoord.dimension()) {
                closest = iterCoord;
                continue;
            }
            if (pos.dimension() == closest.dimension() && pos.dimension() != iterCoord.dimension() || !(pos.pos().distSqr((Vec3i)closest.pos()) > pos.pos().distSqr((Vec3i)iterCoord.pos()))) continue;
            closest = iterCoord;
        }
        return closest;
    }
}

