/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity.ai;

import java.util.List;
import java.util.function.Predicate;
import mekanism.common.entity.EntityRobit;
import mekanism.common.entity.ai.RobitAIBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.phys.AABB;

public class RobitAIPickup
extends RobitAIBase {
    private static final int SEARCH_RADIUS = 10;
    private static final int SEARCH_RADIUS_SQ = 100;
    private final Predicate<Entity> itemPredicate = entity -> {
        ItemEntity item;
        return !entity.isSpectator() && entity instanceof ItemEntity && this.theRobit.isItemValid(item = (ItemEntity)entity);
    };
    private ItemEntity closest;

    public RobitAIPickup(EntityRobit entityRobit, float speed) {
        super(entityRobit, speed);
    }

    public boolean canUse() {
        if (!this.theRobit.getDropPickup()) {
            return false;
        }
        PathNavigation navigator = this.getNavigator();
        if (this.validateClosest() && navigator.createPath((Entity)this.closest, 0) != null) {
            return true;
        }
        this.closest = null;
        double closestDistance = -1.0;
        List items = this.theRobit.level().getEntitiesOfClass(ItemEntity.class, new AABB(this.theRobit.getX() - 10.0, this.theRobit.getY() - 10.0, this.theRobit.getZ() - 10.0, this.theRobit.getX() + 10.0, this.theRobit.getY() + 10.0, this.theRobit.getZ() + 10.0), this.itemPredicate);
        for (ItemEntity entity : items) {
            double distance = this.theRobit.distanceToSqr((Entity)entity);
            if (!(distance <= 100.0) || closestDistance != -1.0 && !(distance < closestDistance) || navigator.createPath((Entity)entity, 0) == null) continue;
            this.closest = entity;
            closestDistance = distance;
        }
        return this.closest != null;
    }

    private boolean validateClosest() {
        return this.closest != null && this.theRobit.isItemValid(this.closest) && this.closest.level().dimension() == this.theRobit.level().dimension() && this.theRobit.distanceToSqr((Entity)this.closest) <= 100.0;
    }

    public boolean canContinueToUse() {
        return this.theRobit.getDropPickup() && this.validateClosest() && !this.getNavigator().isDone() && !this.theRobit.getEnergyContainer().isEmpty();
    }

    public void tick() {
        if (this.theRobit.getDropPickup()) {
            this.updateTask((Entity)this.closest);
        }
    }
}

