/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content.builder;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.common.Mekanism;
import mekanism.common.integration.crafttweaker.content.CrTContentUtils;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister(loaders={"mekanismcontent"})
@ZenCodeType.Name(value="mods.mekanism.content.builder.ChemicalBuilder")
public class CrTChemicalBuilder {
    private final ChemicalBuilder builder;
    @Nullable
    private Integer colorRepresentation;

    private CrTChemicalBuilder(ChemicalBuilder builder) {
        this.builder = builder;
    }

    @ZenCodeType.Method
    @Deprecated(forRemoval=true, since="10.7.11")
    public CrTChemicalBuilder with(ChemicalAttribute attribute) {
        this.builder.with(attribute);
        return this;
    }

    @ZenCodeType.Method
    public CrTChemicalBuilder tint(int tint) {
        this.builder.tint(tint);
        return this;
    }

    @ZenCodeType.Method
    public CrTChemicalBuilder colorRepresentation(int color) {
        this.colorRepresentation = color;
        return this;
    }

    @ZenCodeType.Method
    public void build(String name) {
        this.build(Mekanism.hooks.craftTweaker.rl(name));
    }

    protected void build(ResourceLocation registryName) {
        Chemical chemical = ChemicalUtil.chemical(this.builder, this.colorRepresentation);
        CrTContentUtils.queueChemicalForRegistration(registryName, chemical);
    }

    @ZenCodeType.Method
    @Deprecated(forRemoval=true, since="10.7.11")
    public CrTChemicalBuilder ore(ResourceLocation oreTagLocation) {
        this.builder.ore(oreTagLocation);
        return this;
    }

    @ZenCodeType.Method
    @Deprecated(forRemoval=true, since="10.7.11")
    public CrTChemicalBuilder ore(KnownTag<Item> oreTag) {
        this.builder.ore((TagKey<Item>)oreTag.getTagKey());
        return this;
    }

    @ZenCodeType.Method
    @Deprecated(forRemoval=true, since="10.7.11")
    public CrTChemicalBuilder gaseous() {
        this.builder.gaseous();
        return this;
    }

    @ZenCodeType.Method
    public static CrTChemicalBuilder builder(@ZenCodeType.Optional ResourceLocation textureLocation) {
        return new CrTChemicalBuilder(textureLocation == null ? ChemicalBuilder.builder() : ChemicalBuilder.builder(textureLocation));
    }

    @ZenCodeType.Method
    public static CrTChemicalBuilder infuseType() {
        return new CrTChemicalBuilder(ChemicalBuilder.infuseType());
    }

    @ZenCodeType.Method
    public static CrTChemicalBuilder pigment() {
        return new CrTChemicalBuilder(ChemicalBuilder.pigment());
    }

    @ZenCodeType.Method
    public static CrTChemicalBuilder clean() {
        return new CrTChemicalBuilder(ChemicalBuilder.cleanSlurry());
    }

    @ZenCodeType.Method
    public static CrTChemicalBuilder dirty() {
        return new CrTChemicalBuilder(ChemicalBuilder.dirtySlurry());
    }
}

