/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import net.minecraft.core.Holder;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.NotNull;

public abstract class ItemSpecialArmor
extends ArmorItem {
    protected ItemSpecialArmor(Holder<ArmorMaterial> material, ArmorItem.Type armorType, Item.Properties properties) {
        super(material, armorType, properties);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return ((ArmorMaterial)this.material.value()).enchantmentValue() > 0 && stack.getMaxStackSize() == 1;
    }

    public boolean isBookEnchantable(@NotNull ItemStack stack, @NotNull ItemStack book) {
        return this.isEnchantable(stack) && super.isBookEnchantable(stack, book);
    }

    public boolean isPrimaryItemFor(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.isPrimaryItemFor(stack, enchantment);
    }

    public boolean supportsEnchantment(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment) {
        return this.isEnchantable(stack) && super.supportsEnchantment(stack, enchantment);
    }
}

