/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.integration.curios.CuriosIntegration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IFreeRunnerItem {
    public FreeRunnerMode getFreeRunnerMode(ItemStack var1);

    @Nullable
    public IEnergyContainer getRunnerEnergyContainer(ItemStack var1);

    @NotNull
    public static ItemStack getActiveFreeRunners(LivingEntity entity) {
        return IFreeRunnerItem.getFreeRunners(entity, stack -> {
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof IFreeRunnerItem) {
                IFreeRunnerItem freeRunners = (IFreeRunnerItem)patt0$temp;
                IEnergyContainer energyContainer = freeRunners.getRunnerEnergyContainer((ItemStack)stack);
                return energyContainer != null && !energyContainer.isEmpty();
            }
            return false;
        });
    }

    @NotNull
    public static ItemStack getPrimaryFreeRunners(LivingEntity entity) {
        return IFreeRunnerItem.getFreeRunners(entity, stack -> stack.getItem() instanceof IFreeRunnerItem);
    }

    private static ItemStack getFreeRunners(LivingEntity entity, Predicate<ItemStack> matcher) {
        ItemStack feet = entity.getItemBySlot(EquipmentSlot.FEET);
        if (matcher.test(feet)) {
            return feet;
        }
        if (Mekanism.hooks.curios.isLoaded()) {
            return CuriosIntegration.findFirstCurio(entity, matcher);
        }
        return ItemStack.EMPTY;
    }

    @NothingNullByDefault
    public static enum FreeRunnerMode implements IIncrementalEnum<FreeRunnerMode>,
    IHasTextComponent.IHasEnumNameTextComponent,
    StringRepresentable
    {
        NORMAL(MekanismLang.FREE_RUNNER_NORMAL, EnumColor.DARK_GREEN, true, true),
        SAFETY(MekanismLang.FREE_RUNNER_SAFETY, EnumColor.ORANGE, true, false),
        DISABLED(MekanismLang.FREE_RUNNER_DISABLED, EnumColor.DARK_RED, false, false);

        public static final Codec<FreeRunnerMode> CODEC;
        public static final IntFunction<FreeRunnerMode> BY_ID;
        public static final StreamCodec<ByteBuf, FreeRunnerMode> STREAM_CODEC;
        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final boolean preventsFallDamage;
        private final boolean providesStepBoost;
        private final ILangEntry langEntry;
        private final EnumColor color;

        private FreeRunnerMode(ILangEntry langEntry, EnumColor color, boolean preventsFallDamage, boolean providesStepBoost) {
            this.preventsFallDamage = preventsFallDamage;
            this.providesStepBoost = providesStepBoost;
            this.langEntry = langEntry;
            this.color = color;
        }

        public boolean preventsFallDamage() {
            return this.preventsFallDamage;
        }

        public boolean providesStepBoost() {
            return this.providesStepBoost;
        }

        @Override
        public Component getTextComponent() {
            return this.langEntry.translateColored(this.color);
        }

        @Override
        public FreeRunnerMode byIndex(int index) {
            return BY_ID.apply(index);
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            CODEC = StringRepresentable.fromEnum(FreeRunnerMode::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])FreeRunnerMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

