/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import mekanism.api.math.MathUtils;
import mekanism.api.radiation.capability.IRadiationEntity;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.lib.radiation.LevelAndMaxMagnitude;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.network.to_client.radiation.PacketEnvironmentalRadiationData;
import mekanism.common.network.to_client.radiation.PacketPlayerRadiationData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="mekanism")
public class PlayerExposure {
    private static final Map<UUID, PreviousRadiationData> playerEnvironmentalExposureMap = new Object2ObjectOpenHashMap();
    private static final Map<UUID, PreviousRadiationData> playerExposureMap = new Object2ObjectOpenHashMap();

    public static void tickServer(ServerPlayer player) {
        PlayerExposure.updateEntityRadiation((LivingEntity)player);
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        LivingEntity living;
        Entity entity;
        Level world = event.getEntity().level();
        if (!world.isClientSide() && (entity = event.getEntity()) instanceof LivingEntity && !((living = (LivingEntity)entity) instanceof Player) && !world.tickRateManager().isEntityFrozen((Entity)living)) {
            PlayerExposure.updateEntityRadiation(living);
        }
    }

    public static void clear() {
        playerEnvironmentalExposureMap.clear();
        playerExposureMap.clear();
    }

    private static void updateEntityRadiation(LivingEntity entity) {
        if (!RadiationManager.isGlobalRadiationEnabled()) {
            return;
        }
        IRadiationEntity radiationCap = (IRadiationEntity)entity.getCapability(Capabilities.RADIATION_ENTITY);
        if (entity.level().getRandom().nextInt(20) == 0) {
            Player player;
            double magnitude = RadiationManager.get().getRadiationLevel((Entity)entity);
            if (magnitude > RadiationManager.get().baselineRadiation() && (!(entity instanceof Player) || MekanismUtils.isPlayingMode(player = (Player)entity))) {
                RadiationManager.get().radiate(entity, magnitude / 3600.0);
            }
            if (radiationCap != null) {
                radiationCap.decay();
            }
        }
        if (radiationCap != null) {
            radiationCap.update();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                double radiation = radiationCap.getRadiation();
                PreviousRadiationData previousRadiationData = playerExposureMap.get(player.getUUID());
                PreviousRadiationData relevantData = PreviousRadiationData.compareTo(previousRadiationData, radiation);
                if (relevantData != null) {
                    playerExposureMap.put(player.getUUID(), relevantData);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketPlayerRadiationData(radiation), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public static void resetPlayer(UUID uuid) {
        playerEnvironmentalExposureMap.remove(uuid);
        playerExposureMap.remove(uuid);
    }

    public static void updateClientRadiation(ServerPlayer player) {
        LevelAndMaxMagnitude levelAndMaxMagnitude = RadiationManager.get().getRadiationLevelAndMaxMagnitude((Entity)player);
        PreviousRadiationData previousRadiationData = playerEnvironmentalExposureMap.get(player.getUUID());
        PreviousRadiationData relevantData = PreviousRadiationData.compareTo(previousRadiationData, levelAndMaxMagnitude.level());
        if (relevantData != null) {
            playerEnvironmentalExposureMap.put(player.getUUID(), relevantData);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketEnvironmentalRadiationData(levelAndMaxMagnitude), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    static void updateClientRadiationForAll(ResourceKey<Level> dimension) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                if (player.level().dimension() != dimension) continue;
                PlayerExposure.updateClientRadiation(player);
            }
        }
    }

    static void updateClientRadiationForAll() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                PlayerExposure.updateClientRadiation(player);
            }
        }
    }

    private record PreviousRadiationData(double magnitude, int power, double base) {
        private static int getPower(double magnitude) {
            return MathUtils.clampToInt(Math.floor(Math.log10(magnitude)));
        }

        @Nullable
        private static PreviousRadiationData compareTo(@Nullable PreviousRadiationData previousRadiationData, double magnitude) {
            int power;
            if (previousRadiationData == null || Math.abs(magnitude - previousRadiationData.magnitude) >= previousRadiationData.base) {
                return PreviousRadiationData.getData(magnitude, PreviousRadiationData.getPower(magnitude));
            }
            if (magnitude < previousRadiationData.magnitude && (power = PreviousRadiationData.getPower(magnitude)) < previousRadiationData.power) {
                return PreviousRadiationData.getData(magnitude, power);
            }
            return null;
        }

        private static PreviousRadiationData getData(double magnitude, int power) {
            int siPower = Math.floorDiv(power, 3) * 3;
            double base = Math.pow(10.0, siPower - 2);
            return new PreviousRadiationData(magnitude, power, base);
        }
    }
}

