/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.security;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BlockSecurityUtils
implements IBlockSecurityUtils {
    private static final BlockCapability<IOwnerObject, Void> OWNER_CAPABILITY = BlockCapability.createVoid((ResourceLocation)Capabilities.OWNER_OBJECT_NAME, IOwnerObject.class);
    private static final BlockCapability<ISecurityObject, Void> SECURITY_CAPABILITY = BlockCapability.createVoid((ResourceLocation)Capabilities.SECURITY_OBJECT_NAME, ISecurityObject.class);

    public static BlockSecurityUtils get() {
        return (BlockSecurityUtils)INSTANCE;
    }

    @Override
    public BlockCapability<IOwnerObject, Void> ownerCapability() {
        return OWNER_CAPABILITY;
    }

    @Override
    public BlockCapability<ISecurityObject, Void> securityCapability() {
        return SECURITY_CAPABILITY;
    }

    @Override
    public boolean canAccess(Player player, Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity) {
        CachingCapabilityLookup lookup = new CachingCapabilityLookup(level, pos, state, blockEntity);
        return ISecurityUtils.INSTANCE.canAccess(player, lookup, CachingCapabilityLookup::securityCapability, CachingCapabilityLookup::ownerCapability);
    }

    @Override
    public boolean canAccess(@Nullable UUID player, Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity) {
        CachingCapabilityLookup lookup = new CachingCapabilityLookup(level, pos, state, blockEntity);
        return ISecurityUtils.INSTANCE.canAccess(player, lookup, CachingCapabilityLookup::securityCapability, CachingCapabilityLookup::ownerCapability, level.isClientSide());
    }

    @Override
    public SecurityMode getSecurityMode(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity) {
        CachingCapabilityLookup lookup = new CachingCapabilityLookup(level, pos, state, blockEntity);
        return ISecurityUtils.INSTANCE.getSecurityMode(lookup, CachingCapabilityLookup::securityCapability, CachingCapabilityLookup::ownerCapability, level.isClientSide());
    }

    public void securityChanged(Set<Player> playersUsing, Level level, BlockPos pos, @Nullable BlockEntity target, SecurityMode old, SecurityMode mode) {
        if (!playersUsing.isEmpty() && ISecurityUtils.INSTANCE.moreRestrictive(old, mode)) {
            CachingCapabilityLookup lookup = new CachingCapabilityLookup(level, pos, null, target);
            for (Player player : new ObjectOpenHashSet(playersUsing)) {
                if (ISecurityUtils.INSTANCE.canAccess(player, lookup, CachingCapabilityLookup::securityCapability, CachingCapabilityLookup::ownerCapability)) continue;
                player.closeContainer();
            }
        }
    }

    private static class CachingCapabilityLookup {
        private final Level level;
        private final BlockPos pos;
        @Nullable
        private final BlockState knownState;
        @Nullable
        private final BlockEntity knownBlockEntity;
        @Nullable
        private BlockTarget target;
        @Nullable
        private ISecurityObject securityObject;
        @Nullable
        private IOwnerObject ownerObject;

        CachingCapabilityLookup(Level level, BlockPos pos, @Nullable BlockState knownState, @Nullable BlockEntity knownBlockEntity) {
            this.level = level;
            this.pos = pos;
            this.knownState = knownState;
            this.knownBlockEntity = knownBlockEntity;
        }

        private BlockTarget getTarget() {
            if (this.target == null) {
                BlockState state = this.knownState;
                BlockEntity blockEntity = this.knownBlockEntity;
                if (blockEntity == null) {
                    if (state == null) {
                        state = this.level.getBlockState(this.pos);
                    }
                    if (state.hasBlockEntity()) {
                        blockEntity = this.level.getBlockEntity(this.pos);
                    }
                } else if (state == null) {
                    state = blockEntity.getBlockState();
                }
                this.target = new BlockTarget(state, blockEntity);
            }
            return this.target;
        }

        @Nullable
        ISecurityObject securityCapability() {
            if (this.securityObject == null) {
                BlockTarget blockTarget = this.getTarget();
                this.securityObject = IBlockSecurityUtils.INSTANCE.securityCapability(this.level, this.pos, blockTarget.state(), blockTarget.blockEntity());
            }
            return this.securityObject;
        }

        @Nullable
        IOwnerObject ownerCapability() {
            if (this.ownerObject == null) {
                BlockTarget blockTarget = this.getTarget();
                this.ownerObject = IBlockSecurityUtils.INSTANCE.ownerCapability(this.level, this.pos, blockTarget.state(), blockTarget.blockEntity());
            }
            return this.ownerObject;
        }

        private record BlockTarget(BlockState state, @Nullable BlockEntity blockEntity) {
        }
    }
}

