/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter.acceptor;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.acceptor.AcceptorInfo;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class AbstractAcceptorCache<ACCEPTOR, INFO extends AcceptorInfo<ACCEPTOR>> {
    private final Map<Direction, RefreshListener> cachedListeners = new EnumMap<Direction, RefreshListener>(Direction.class);
    private final Map<Direction, INFO> cachedAcceptors = new EnumMap<Direction, INFO>(Direction.class);
    private final TileEntityTransmitter transmitterTile;
    public byte currentAcceptorConnections = 0;

    protected AbstractAcceptorCache(TileEntityTransmitter transmitterTile) {
        this.transmitterTile = transmitterTile;
    }

    public void initializeCache(ServerLevel level) {
        if (this.cachedAcceptors.isEmpty()) {
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockPos pos = this.transmitterTile.getBlockPos().relative(side);
                this.cachedAcceptors.put(side, this.initializeCache(level, pos, side.getOpposite(), this.getRefreshListener(side)));
            }
        }
    }

    protected abstract INFO initializeCache(ServerLevel var1, BlockPos var2, Direction var3, RefreshListener var4);

    @Nullable
    public ACCEPTOR getCachedAcceptor(Direction side) {
        return Transmitter.connectionMapContainsSide(this.currentAcceptorConnections, side) ? (ACCEPTOR)this.getConnectedAcceptor(side) : null;
    }

    public List<ACCEPTOR> getConnectedAcceptors(Set<Direction> sides) {
        ArrayList<ACCEPTOR> acceptors = new ArrayList<ACCEPTOR>(sides.size());
        for (Direction side : sides) {
            ACCEPTOR connectedAcceptor = this.getConnectedAcceptor(side);
            if (connectedAcceptor == null) continue;
            acceptors.add(connectedAcceptor);
        }
        return acceptors;
    }

    @Nullable
    public ACCEPTOR getConnectedAcceptor(Direction side) {
        AcceptorInfo acceptorInfo = (AcceptorInfo)this.cachedAcceptors.get(side);
        return acceptorInfo == null ? null : (ACCEPTOR)acceptorInfo.acceptor();
    }

    private RefreshListener getRefreshListener(@NotNull Direction side) {
        RefreshListener listener = this.cachedListeners.get(side);
        if (listener == null) {
            listener = new RefreshListener(this.transmitterTile, side);
            this.cachedListeners.put(side, listener);
        }
        return listener;
    }

    public static class RefreshListener
    implements Runnable,
    BooleanSupplier {
        private final WeakReference<TileEntityTransmitter> tile;
        private final Direction side;

        private RefreshListener(TileEntityTransmitter tile, Direction side) {
            this.tile = new WeakReference<TileEntityTransmitter>(tile);
            this.side = side;
        }

        @Override
        public boolean getAsBoolean() {
            return this.tile.get() != null;
        }

        @Override
        public void run() {
            Transmitter<?, ?, ?> transmitter;
            TileEntityTransmitter transmitterTile = (TileEntityTransmitter)this.tile.get();
            if (transmitterTile != null && (transmitter = transmitterTile.getTransmitter()).isValid()) {
                transmitter.markDirtyAcceptor(this.side);
            }
        }
    }
}

