/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.particle;

import mekanism.common.content.sps.SPSMultiblockData;
import mekanism.common.lib.Color;
import mekanism.common.lib.effect.CustomEffect;
import mekanism.common.lib.math.Quaternion;
import mekanism.common.util.MekanismUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class SPSOrbitEffect
extends CustomEffect {
    private static final ResourceLocation TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "sps_orbit_effect.png");
    private static final Color COLOR = Color.rgbai(102, 215, 237, 240);
    private final Vec3 center;
    private final Vec3 start;
    private final Vec3 axis;
    private float speed = 0.5f;
    private SPSMultiblockData multiblock;

    public SPSOrbitEffect(SPSMultiblockData multiblock, Vec3 center) {
        super(TEXTURE, 1);
        this.multiblock = multiblock;
        this.center = center;
        float radius = 1.0f + (float)this.rand.nextDouble();
        this.start = this.randVec().scale((double)radius);
        this.axis = this.randVec();
        this.setPos(this.center.add(this.start));
        this.setScale(0.01f + this.rand.nextFloat() * 0.04f);
        this.setColor(COLOR);
    }

    public void updateMultiblock(SPSMultiblockData multiblock) {
        this.multiblock = multiblock;
    }

    @Override
    public boolean tick() {
        if (super.tick() || !this.multiblock.isFormed()) {
            return true;
        }
        this.speed = (float)Math.log10(this.multiblock.lastReceivedEnergy);
        return false;
    }

    @Override
    public Vec3 getPos(float partialTick) {
        return this.center.add((Vec3)Quaternion.rotate(this.start, this.axis, ((float)this.ticker + partialTick) * this.speed));
    }
}

