/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import java.util.List;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.recipe.lookup.cache.type.ComponentSensitiveInputCache;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

public class ItemInputCache<RECIPE extends MekanismRecipe<?>>
extends ComponentSensitiveInputCache<Item, ItemStack, ItemStackIngredient, RECIPE> {
    public ItemInputCache() {
        super(ItemStackLinkedSet.TYPE_AND_TAG);
    }

    @Override
    public boolean mapInputs(RECIPE recipe, ItemStackIngredient inputIngredient) {
        return this.mapIngredient(recipe, inputIngredient.ingredient().ingredient());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean mapIngredient(RECIPE recipe, Ingredient input) {
        DataComponentIngredient componentIngredient;
        if (input.isSimple()) {
            for (ItemStack item : input.getItems()) {
                if (item.isEmpty()) continue;
                this.addInputCache(item.getItem(), recipe);
            }
            return false;
        }
        ICustomIngredient iCustomIngredient = input.getCustomIngredient();
        if (iCustomIngredient instanceof CompoundIngredient) {
            boolean result;
            Object list;
            CompoundIngredient compoundIngredient = (CompoundIngredient)iCustomIngredient;
            try {
                list = compoundIngredient.children();
                List children = list;
                result = false;
                list = children.iterator();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            while (true) {
                if (!list.hasNext()) {
                    return result;
                }
                Ingredient child = (Ingredient)list.next();
                result |= this.mapIngredient(recipe, child);
            }
        }
        iCustomIngredient = input.getCustomIngredient();
        if (!(iCustomIngredient instanceof DataComponentIngredient) || !(componentIngredient = (DataComponentIngredient)iCustomIngredient).isStrict()) return true;
        for (ItemStack item : input.getItems()) {
            this.addNbtInputCache(item.copyWithCount(1), recipe);
        }
        return false;
    }

    @Override
    protected Item createKey(ItemStack stack) {
        return stack.getItem();
    }

    @Override
    public boolean isEmpty(ItemStack input) {
        return input.isEmpty();
    }
}

